<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: Audio.php 31913 2015-03-13 03:01:48Z astarostin $
 * ------------------------------------------------------------------------------
 * This class represents logic for Audio object
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */

class Audio extends Device
{
	public function __construct()
	{
		parent::__construct("audio", "D", "A");
	}

	/**
	 * @throws Exception
	 * @param array $attributes
	 * @param  int|null $parentObj not used
	 * @return void
	 */
	public function create(array $attributes, $parentObj = null)
	{
		throw new Exception(sprintf(__("Cannot create object with type=%s"), $this->type));
	}

	/**
	 * @throws Exception
	 * @param  $obj
	 * @param  bool $onlyMark
	 * @return void
	 */
	public function delete($obj, $onlyMark = true)
	{
		throw new Exception(sprintf(__("Cannot delete object with type=%s"), $this->type));
	}
}
