<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id:$
 * ------------------------------------------------------------------------------
 * description
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2012
 * ------------------------------------------------------------------------------
 */

class API_POST_Public extends API
{
	/**
	 * login to system and create new session
	 *
	 * @docBlock
	 * # Login
	 * ## Login to system
	 * #### Request
	 * > POST /api/call/login
	 * #### Response
	 * > 200
	 * > Content-Type: application/json
	 * > {"DEFAULT_ROLE":31,"parameters":{"token":"65bdb82c1ea1bbc2e5cb6f6932974ca909038fff4e7aa84c950048a269ef0e9c"},"error":"","code":200}
	 *
	 * @static
	 * @param string $name user name
	 * @param string $credentials sha512(${encryptionKey} + sha512(${password}) + ${encryptionKey})
	 * @param string $password password for LDAP login (do not use for now)
	 * @return array
	 */
	public static function login($name, $credentials, $password = null)
	{
		$sessionManager = new SessionManager();
		$sessionManager->startSession($name, $credentials, $password);

		$user = new User();
		$attributes = $user->getAttributes($_SESSION[SESSION_USERID]);
		$DEFAULT_ROLE = intval($attributes["DEFAULT_ROLE"], 10);
		if ($DEFAULT_ROLE == 0) $DEFAULT_ROLE = null;

		return array(
			"DEFAULT_ROLE" => $DEFAULT_ROLE,
			"parameters" => array (
				"token" => $sessionManager::getCSRFToken()
			)
		);
	}
}
