<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id:$
 * ------------------------------------------------------------------------------
 * description
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2012
 * ------------------------------------------------------------------------------
 */

class API_GET_Public extends API
{
	/**
	 * get information for login to system
	 *
	 * @docBlock
	 * # Login
	 * ## Get login information
	 * #### Request
	 * > GET /api/call/getLoginInfo
	 * #### Response
	 * > 200
	 * > Content-Type: application/json
	 * > {"loginInfo":{"encryptionKey":"daa604a6799aeb543a595d812c7c8c018fb74e6c91d5cc2ace33d903153482fa","loginTTL":5},"error":"","code":200}
	 *
	 * @static
	 * @return array
	 */
	public static function getLoginInfo()
	{
		$sessionManager = new SessionManager();

		return array(
			"loginInfo" => $sessionManager->getLoginInfo()
		);
	}

	/**
	 * close current session
	 *
	 * @docBlock
	 * # Login
	 * ## Close current session
	 * #### Request
	 * > GET /api/call/logout
	 * #### Response
	 * > 200
	 * > Content-Type: application/json
	 * > {"error":"","code":200}
	 *
	 * @static
	 */
	public static function logout()
	{
		SessionManager::closeSession();
	}

	/**
	 * Get version information
	 *
	 * @docBlock
	 * # Login
	 * ## Get version information
	 * #### Request
	 * > GET /api/call/version
	 * #### Response
	 * > 200
	 * > Content-Type: application/json
	 * > {"api":1.3,"error":"","code":200}
	 *
	 * @return array
	 */
	public static function version()
	{
		return array(
			"api" => 1.5
		);
	}
}
