<?php
/**
 * @version $Id: bootstrap.php 32455 2015-05-25 06:21:17Z astarostin $
 * ------------------------------------------------------------------------------
 *
 * Different initialisation procedures
 *
 * This file should be first in require (include) list
 *
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */

/**
 * The directory in which SKM are located
 * @define "$_SERVER['APL']" "/opt/sarch/"
 */
define('APL_PATH', $_SERVER['APL']);

/**
 * The directory in which SKM configs are located
 * @define "$_SERVER['APL_VAR']" "/var/sarch/"
 */
define('APL_VAR_PATH', $_SERVER['APL_VAR']);

/**
 * The directory in which classes are located.
 */
define('CLASS_PATH', APL_PATH . '/api/lib/php/classes');

/**
 * Set the PHP error reporting level. If you set this in php.ini, you remove this.
 * @see  http://php.net/error_reporting
 *
 * When developing your application, it is highly recommended to enable notices
 * and strict warnings. Enable them by using: E_ALL | E_STRICT
 *
 * In a production environment, it is safe to ignore notices and strict warnings.
 * Disable them by using: E_ALL ^ E_NOTICE
 *
 * When using a legacy application with PHP >= 5.3, it is recommended to disable
 * deprecated notices. Disable with: E_ALL & ~E_DEPRECATED
 */
error_reporting(E_ALL & ~E_STRICT);

ini_set("session.gc_maxlifetime", 43200);
ini_set("session.cookie_secure", isset($_SERVER["HTTPS"]));
ini_set("memory_limit", "128M");

/**
 * define session variable names
 */
define("SESSION_DEBUG", false);
define("SESSION_STATUS", "status");
define("SESSION_USERNAME", "username");
define("SESSION_USERID", "userid");
define("SESSION_IP", "user_ip");
define("SESSION_USER_AGENT", "user_agent");
define("SESSION_CSRF_TOKEN", "csrf_token");
define("SESSION_CSRF_TOKEN_SALT", "csrf_token_salt");
define("SESSION_TIMEZONE", "timezone");
define("SESSION_ENCRYPTIONKEY", "encryptionkey");
define("SESSION_MCASTSUPPORTED", "mcastsupported");
define("SESSION_MEDIA_TRANSPORT", "media_transport");
define("SESSION_NTLM_AUTH", "ntlm_auth");

$_SESSION[SESSION_NTLM_AUTH] = false;

/**
 * Enable auto-loader.
 *
 * @see  http://php.net/spl_autoload_register
 */
require CLASS_PATH . DIRECTORY_SEPARATOR . "AutoLoad.php";
spl_autoload_register(array('AutoLoad', 'auto_load'));


/**
 * Set the default locale.
 *
 * @see  http://php.net/setlocale
 */
//setlocale(LC_ALL, 'en_US.utf-8');
require_once APL_PATH . '/api/lib/php/i18n.php';

/**
 * Set the default time zone.
 *
 * @see  http://php.net/timezones
 */
if (!isset($_SESSION[SESSION_TIMEZONE]))
{
	$systemStatus = Node::getSystemStatus(true);
	if (!in_array($systemStatus["status"], array("OFFLINE", "BROKEN")))
	{
		if (DB::checkConnection()){
			$_SESSION[SESSION_TIMEZONE] = Identity::getAttribute("TIME_ZONE");
		}
	} else {
		$_SESSION[SESSION_TIMEZONE] = "UTC";
	}
}
date_default_timezone_set($_SESSION[SESSION_TIMEZONE]);

/**
 * Handle the output stream and set a handler function for handling fatal errors
 */
function ob_error_handler($string)
{
	$error = error_get_last();
	if ($error && $error["type"] == E_USER_ERROR || $error["type"] == E_ERROR)
	{
		$response = array(
			"code" => 500,
			"error" => "Internal Server Error"
		);

		if (SESSION_DEBUG)
		{
			$response["debug"] = array(
				"callstack" => "Fatal error: $error[message] in $error[file] on line $error[line]"
			);
		}

		header('Content-type: application/json; charset=utf-8');

		return json_encode($response);
	}

	return $string;
}
ob_start('ob_error_handler');
