<?php
/**
 * @version $Id:$
 * ------------------------------------------------------------------------------
 * add camera from avatar to system
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2012
 * ------------------------------------------------------------------------------
 */

require_once $_SERVER["APL"] . "/api/lib/php/bootstrap.php";

$_SESSION[SESSION_USERID] = User::ADMIN;

if (($options = getopt("c:u:")) === FALSE)
{
	print("-u required option\n");
	print("-c required option\n");
	exit(1);
}

$avatarUNI = trim($options["u"]);
$list = json_decode(trim($options["c"]), true);

$STATUS = "OK";
$PATH_LIST = "";

$avatar = new Avatar();
$avatarId = $avatar->getId($avatarUNI);

if (!isset($avatarId))
{
	$STATUS = "ERROR: cannot get avatarId for specified avatarUNI=$avatarUNI";
} else {
	// add temporary cameras from avatar
	foreach ($list as $attributes)
	{
		$camera = new Camera();

		$nodeUNI = null;

		$nodeUNI = $avatar->getNodeUni($avatarUNI);
		if (!isset($nodeUNI))
		{
			$STATUS = "ERROR: Cannot get node UNI related to specified avatar UNI";
			break;
		}

		unset($attributes["OBJID"]);
		unset($attributes["DEVID"]);
		unset($attributes["UDID"]);
		unset($attributes["AV_DELIVERY"]);
		unset($attributes["STORAGE_POLICY"]);

		$attributes["AVATARID"] = $avatarId;

		$obj = $camera->create($attributes, $nodeUNI);
		if (!isset($obj))
		{
			print("cannot create camera");
		}
	}

	// return list of objects confs related to avatar for sync
	$childs = $avatar->getObjects($avatarId, $_SESSION[SESSION_USERID]);

	foreach ($childs as $child)
	{
		$obj = $child["obj"];

		$prefix = strtolower($child["subtype"]);
		if ($prefix == "c")
		{
			$prefix = "";
		}

		$confPath = APL_VAR_PATH . "/conf/$prefix$obj/conf";
		while (!is_file($confPath))
		{
			clearstatcache();
			sleep(1);
		}

		$PATH_LIST .= "$obj:$confPath,";
	}
}

print "PATH_LIST=$PATH_LIST\n";
print "STATUS=$STATUS\n";
