<?php
/**
 * @version $Id:$
 * ------------------------------------------------------------------------------
 * add avatar to system
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */

require_once $_SERVER["APL"] . "/api/lib/php/bootstrap.php";

$_SESSION[SESSION_USERID] = User::ADMIN;

if (($options = getopt("a:")) === FALSE)
{
	print("-a required option\n");
	exit(1);
}
$avatar_attributes = json_decode(trim($options["a"]), true);
$UNI = $avatar_attributes["UNI"];

$STATUS = "OK";
$PATH_LIST = "";

// check if avatar already registered
$list = DB::select(
	"SELECT _objs.obj, _objs.node_id
		FROM _objs, _obj_attr
		WHERE
			_objs.obj = _obj_attr.obj
			AND _objs.otype = 'V'
			AND _objs.subtype = '*'
			AND _obj_attr.attr = 'UNI'
			AND _obj_attr.val = ?
			AND _objs.deleted = 0;",
	array($UNI)
);

$avatarObj = null;
$avatarNODEID = null;
if (count($list) > 0)
{
	$avatarObj = $list[0]["obj"];
	$avatarNODEID = $list[0]["node_id"];
}

$NODEID = isset($avatar_attributes["NODEID"]) ? intval($avatar_attributes["NODEID"]) : Node::getMasterNodeId();

// not registered
if (!isset($avatarObj))
{
	// register avatar

	// add avatar
	$node = new Node();
	$AVATAR_REGISTRATION = Template::boolVal($node->getAttribute($NODEID, "AVATAR_REGISTRATION"));
	if (!$AVATAR_REGISTRATION)
	{
		$STATUS = "ERROR: avatar can not be registered on this node";
	} else {
		DB::query("BEGIN;");
		$avatar_attributes["NAME"] = "Avatar " . $avatar_attributes["HOSTNAME"];
		$avatar_attributes["NODEID"] = $NODEID;
		$avatarObj = $node->add("avatar", $avatar_attributes, $NODEID);
		if (isset($avatarObj))
		{
			DB::query("COMMIT;");
		} else {
			$STATUS = "ERROR: cannot create avatar object";
			DB::query("ROLLBACK;");
		}
	}
}

if (isset($avatarObj))
{
	if ($avatarNODEID != $NODEID)
	{
		$STATUS = "ERROR: avatar already registered on another node";
	} else {
		print "OBJ=$avatarObj\n";

		$confPath = APL_VAR_PATH . "/conf/av/$avatarObj/conf";
		while (!is_file($confPath))
		{
			clearstatcache();
			sleep(1);
		}

		// add avatar to path list
		$PATH_LIST = "$avatarObj:$confPath";
	}
}

print "PATH_LIST=$PATH_LIST\n";
print "STATUS=$STATUS\n";
