(function (root, factory) {
	/**
	 * get cookie value
	 *
	 * @param {string} name
	 * @returns {string}
	 */
	function readCookie(name)
	{
		var nameEQ = name + "=";
		var cookies = document.cookie.split(';');
		for(var i = 0; i < cookies.length; i++)
		{
			var cookie = cookies[i];
			while (cookie.charAt(0) === ' ')
			{
				cookie = cookie.substring(1, cookie.length);
			}
			if (cookie.indexOf(nameEQ) == 0)
				return cookie.substring(nameEQ.length, cookie.length);
		}
		return null;
	}

	var language = readCookie("language") || 'en_US';
	var localeFile = "/sdi/locale/" + language + ".json";

	if (typeof define === 'function' && define.amd) {
		// AMD. Register as an anonymous module.
		define(["gettext", "json!" + localeFile], factory);
	} else {
		function getLocaleData(localeFile)
		{
			var gt = new Gettext();
			var data = gt.sjax(localeFile);
			if (!data) return;

			return gt.JSON(data);
		}

		factory(root.Gettext, getLocaleData(localeFile));
	}
}(this, function(Gettext, localeData){
	"use strict";

	window.__ = __;
	window.__n = __n;

	var gt = new Gettext({
		domain: 'admin',
		locale_data: localeData
	});

	/**
	 *
	 * @param {string} message
	 * @param {string} [context]
	 * @returns {string}
	 */
	function __(message, context)
	{
		var str;
		if (context)
		{
			str = gt.pgettext(context, message);
		} else {
			str = gt.gettext(message);
		}
		return str.replace(new RegExp('"', 'g'), '&quot;');
	}

	/**
	 *
	 * @param {string} message
	 * @param {string} message_plural
	 * @param {number} num
	 * @param {string} context
	 * @returns {string}
	 * @private
	 */
	function __n(message, message_plural, num, context)
	{
		var str;
		if (context)
		{
			str = gt.npgettext(context, message, message_plural, num);
		} else {
			str = gt.ngettext(message, message_plural, num);
		}
		return str.replace(new RegExp('"', 'g'), '&quot;');
	}
}));
