/**
 * Live Synchronizer implementation
 *
 * @param {PlayerGroup} playerGroup
 * @constructor
 */
function LiveSyncImpl(playerGroup)
{
	this.submitCommand = lsync_submitCommand;
	this.catchUpWithGroup = lsync_catchUpWithGroup;
	this.onPlayerStatusChange = lsync_onPlayerStatusChange;
	this.onSync = lsync_onSync;

	// implementation
	this.id = "LiveSyncImpl";
	this.group = playerGroup;
	this._startPlaying = lsync_startPlaying;
	this._checkIfGroupStopped = lsync_checkIfGroupStopped;
}


//
// submitCommand
//
function lsync_submitCommand(command) {
	//this.group.log("lsi:submitCommand", command.commandText());

	var bOk = false;

	// command dispatcher
	if (command.cmd == 0) {
		// STOP
		//this.group.log("lsi:submitCommand", 'stop');

		this.group.command = command;
		this.group.setStatus(1, 0);

		for(var i = 0; i < this.group.players.length; i++) {
			if (this.group.players[i].player.contextType != 0) {
				this.group.players[i].player.stop();
			}
			this.group.players[i].reset();
		}
		this.group.setStatus(2, 3);
		bOk = true;
	}
	else if (command.cmd == 1) {
		// PAUSE
		this.group.command = command;
		this.group.setStatus(1, 0);

		for(var i = 0; i < this.group.players.length; i++) {
			if (this.group.players[i].player.contextType != 0) {
				this.group.players[i].player.pause();
			}
			this.group.players[i].reset();
		}
		this.group.setStatus(2, 0);
		bOk = true;
	}
	else if (command.cmd == 2) {
		// PLAY
		if (this.group.command.cmd == 2 && this.group.command.status == 1) { // active playback
			if (this.group.command.direction == command.direction && command.timestamp == null) {
				// change speed command
				this.group.command.speed = command.speed;
				for(var i = 0; i < this.group.players.length; i++) {
					var pcommand = this.group.players[i].player.command;
        	  		if (pcommand.cmd == 2 && pcommand.status == 1) {
						// set new speed
						this.group.players[i].player.play(command.direction, command.speed);
					}
				}
				bOk = true;
			}
			else {
				bOk = this._startPlaying(command);
			}
		}
		else {
			bOk = this._startPlaying(command);
		}
	}
	else if (command.cmd == 3 && command.timestamp == null) {
		// PLAYONEFRAME
	   	for(var i = 0; i < this.group.players.length; i ++) {
			this.group.players[i].player.displayMessage("playOneFrame is not supported");
		}
	}
	else if (command.cmd == 3) {
		// PLAYONEFRAMETS
	   	for(var i = 0; i < this.group.players.length; i ++) {
			this.group.players[i].player.displayMessage("playOneFrame is not supported");
		}
	}

	return bOk;
}


//
// catchUpWithGroup
//
function lsync_catchUpWithGroup(player) {
	//this.group.log("lsi:catchUpWithGroup", "adding player " + player.id);
	//this.group.log('lsi:catchUpWithGroup', 'group command' +  this.group.command.commandText() + '/' + this.group.command.statusText() +  ' groupStatus: ' +  this.group.status);

	if (this.group.command.cmd == 2 && this.group.command.status != 3) { // playback
		var plcmd = player.getCommand();
        if (plcmd.cmd == 2 && plcmd.status == 1 && (player.playerImplStatus == 1 || player.playerImplStatus == 2)) {
			// player is already playing live
		} else {
			var futureTS=new Date(); //future timestamp for playing
			futureTS.setFullYear(futureTS.getFullYear() + 1);
			player.play(1,1,futureTS);
		}
	} else if (this.group.command.cmd == 1 || this.group.command.cmd == 3) { // pause/stop
		var futureTS=new Date();
		futureTS.setFullYear(futureTS.getFullYear() + 1);
		player.playOneFrameTS(futureTS);
	} else if (this.group.command.cmd == 2 || this.group.command.status == 3) { // failed to playback
			var futureTS=new Date();
			futureTS.setFullYear(futureTS.getFullYear() + 1);
			player.play(1,1,futureTS);

			this.group.setStatus(1, 1);
	} else {
		player.stop();
	}
}


//
// _startPlaying
// TODO: this is draft version - better implementation is required
//
function lsync_startPlaying(command)
{
	//this.group.log('lsi:_startPlaying','');

	this.group.command = command;
   	this.group.setStatus(1, 1);

   	// no sync start is requred - start playing
	var started = 0;
	var futureTS=new Date(); //future timestamp for playing
	futureTS.setFullYear(futureTS.getFullYear() + 1);
   	for(var i = 0; i < this.group.players.length; i ++) {
		var player = this.group.players[i].player;
		var plcmd = player.getCommand();

        if (plcmd.cmd == 2 && plcmd.status == 1 && (player.playerImplStatus == 1 || player.playerImplStatus == 2)) {
			// player is already playing live
			started++;
		} else if (player.play(1,1,futureTS)) {
			started++;
		}
	}

	if (started == 0) {
		this.group.setStatus(3, 0); // playback failed
		return false;
	}
	return true;
}


//  callbacks /////////////////////////////////////////////////////////////////////
//
//
//
function lsync_onPlayerStatusChange(player, command, status, errorCode) {
	//player and group status: 0 - pause, 1 - play from server, 2 - play from buffer, 3 - stop (disconnect), 4 - sync (player group, archive)
	//command type: 0 -stop, 1-pause, 2-play, 3-playOneFrame or playOneFrameTS
	//command status: 0 - submited, 1-executing, 2-completed, 3-failed
	//setStatus(groupCommandStatus, groupStatus)

	//this.group.log('lsi:onPlayerStatusChange', '[' + player.id + '] command: ' +  command.commandText() + '/' + command.statusText());
	//this.group.log('lsi:onPlayerStatusChange', '[' + player.id + '] status: ' +  status + '/ errorCode: ' + errorCode);
	//this.group.log('lsi:onPlayerStatusChange', 'Start: group command' +  this.group.command.commandText() + '/' + this.group.command.statusText() + ' groupStatus=' +  this.group.status);

	if (this.group.command.cmd == 2 && this.group.command.status == 1) { // play(executing)
		// still stopped
		if (this.group.status == 0 || this.group.status == 3) {
			if (command.cmd == 2 && command.status == 1 && !(this.group.status == 1 || this.group.status ==2 )) { // playback started
				this.group.setStatus(1, 1);
			}
		}
		// playback in progress
		else if (this.group.status == 1 || this.group.status == 2) {
			if (command.cmd == 2 && command.status == 1 && !(this.group.status == 1 || this.group.status == 2)) { // playback started
				this.group.setStatus(1, 1);
			}
			else if (command.cmd == 2 && (command.status == 2 || command.status == 3)) { // playback completed or failed
				// always reset sync data when player has stopped
				this.group.players[this.group.getPlayerPos(player)].syncData.reset();

				// check if group command is completed
				this._checkIfGroupStopped(command.status, 0);
			}
		}
	}
	else if (this.group.command.cmd == 1 && this.group.command.status == 1) { //pause(executing)
		// still playing
		if (this.group.status == 1 || this.group.status == 2) {
			if (command.cmd == 0 && command.status == 1 && !(this.group.status==0)) { // pausing started
				this.group.setStatus(1, 0);
			}
		}
	} else if (this.group.command.cmd == 2 || this.group.command.status == 3) {
		if (command.cmd	== 2 && (command.state == 1 || status == 1)) {
			// if one of player started playing (spontanioussly or kiked off by timer) - change group status
			this.group.getPrimaryPlayerPos();
			this.group.setStatus(1, 1);
		}
	} else if (this.group.command.cmd == 0 || this.group.command.status == 0) {
		if (command.cmd	== 2 && command.state == 1) { // playback
			this.group.getPrimaryPlayerPos();
			this.group.command.play(1, 1, null);
			this.group.setStatus(1, 1);
		} else if (command.cmd	== 2 && (command.state == 2 || command.state == 3)) { // playback failed/completed
			this._checkIfGroupStopped(command.status, 0);
		}
	}

	//this.group.log('lsi:onPlayerStatusChange', 'End: group command' +  this.group.command.commandText() + '/' + this.group.command.statusText() + ' groupStatus=' +  this.group.status);
}


function lsync_checkIfGroupStopped(commandStopStatus, errorCode)
{
	var isVideoInProgress = false;
	var isAudioInProgress = false;
	var audioIndex = null;

	for(var i = 0; i < this.group.players.length; i ++) {
		var cmd = this.group.players[i].player.getCommand();
		if (cmd.status == 1 ) { // in progress
			if (this.group.players[i].player.getParameter('DEVICE_TYPE') == 'A') {
				isAudioInProgress = true;
				audioIndex = i;
			}
			else {
				isVideoInProgress = true;
				break;
			}
		}
	}

	if (isVideoInProgress) {
		this.group.getPrimaryPlayerPos();
		return false;
	}
	else {
		if (isAudioInProgress) {
			// if the only playing stream is audio - stop it
			this.group.players[audioIndex].player.pause();
		}
		this.group.setStatus(commandStopStatus, 0, errorCode);
		return true;
	}
}

//
//
//
function lsync_onSync() {
}
