
// left padding
function dt_twoDigistsPad(number)
{
  return ((number <= 9) ? "0" : "") + number;
}


// convert YYYY-MM-DD hh:mm:ss into number of milliseconds
function dt_strToMsecTS(stdStrTS)
{
  return Date.UTC(stdStrTS.substr(0,4),	stdStrTS.substr(5,2) - 1, stdStrTS.substr(8,2),
         stdStrTS.substr(11,2), stdStrTS.substr(14,2), stdStrTS.substr(17,2), 0);
}


function dt_formatIntTs(msecTS, dateFormat, timeFormat)
{
  var d = new Date();
  d.setTime(msecTS);
  var year = "" + d.getUTCFullYear();
  var month = dt_twoDigistsPad(d.getUTCMonth() + 1);
  var day = dt_twoDigistsPad(d.getUTCDate());
  
  var str = "";
  switch(dateFormat) {
    case "YYYY-MM-DD":
      str = year + "-" + month + "-" + day;
      break;
    case "MM/DD/YYYY":
      str = month + "/" + day + "/" + year;
      break;
    case "DD/MM/YYYY":
      str = day + "/" + month + "/" + year;
      break;
    case "YY-MM-DD":
      str = year.substr(2, 2) + "-" + month + "-" + day;
      break;
    case "MM/DD/YY":
      str = month + "/" + day + "/" + year.substr(2, 2);
      break;
    case "DD:MM:YY":
      str = day + ":" + month + ":" + year.substr(2, 2);
      break;
    default:
	    // skip date part - unsupported format
  }
  
  switch(timeFormat) {
    case "hh:mm:SS.ss":
      str += " " + dt_twoDigistsPad(d.getUTCHours()) + ":" + dt_twoDigistsPad(d.getUTCMinutes()) + 
             ":" + dt_twoDigistsPad(d.getUTCSeconds()) + 
             "." + dt_twoDigistsPad(Math.round(d.getUTCMilliseconds()/10));
      break;
    case "hh:mm:SS":
      str += " " + dt_twoDigistsPad(d.getUTCHours()) + ":" + dt_twoDigistsPad(d.getUTCMinutes()) + 
             ":" + dt_twoDigistsPad(d.getUTCSeconds());
      break;
    case "_hh-mm-SS":
      str += "_" + dt_twoDigistsPad(d.getUTCHours()) + "-" + dt_twoDigistsPad(d.getUTCMinutes()) + 
             "-" + dt_twoDigistsPad(d.getUTCSeconds());
      break;
    case "_hh-mm-SS-ss":
      str += "_" + dt_twoDigistsPad(d.getUTCHours()) + "-" + dt_twoDigistsPad(d.getUTCMinutes()) + 
             "-" + dt_twoDigistsPad(d.getUTCSeconds()) +
             "-" + dt_twoDigistsPad(Math.round(d.getUTCMilliseconds()/10));
      break;
    default:
	  // no time
  }
  return str;
}


function dt_getCurrentUTCMsecTs()
{
  var t = new Date();
  return t.getTime() - t.getTimezoneOffset() * 60 * 1000;
}