<?php
/**
 * @version $Id: call.php 20246 2010-09-21 14:00:04Z teetov $
 * ------------------------------------------------------------------------------
 * Private HTTP API Interface
 * For internal use only
 * ------------------------------------------------------------------------------
 * Author: Andrey Starostin
 * Edited by: Alexey Tsibulnik
 * QA by:
 * Copyright: videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 * example http://192.168.0.18/api/privateCall.php?function=getAttribute&obj=105&attribute=UNI
 * return json object
 * {"error":"","value":"mEt2szJUNExae93iPaZwMQ"}
 * error == "" if no errors else consist error description
 *
 */

require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';

$response = array();
$trusted = false;

$systemStatus = Node::getSystemStatus(true);

if (in_array($systemStatus["status"], array("OFFLINE", "BROKEN")))
{
	$response["error"] = $systemStatus["description"];
	$response["reasons"] = $systemStatus["reasons"];
	$response["code"] = 500;
} else
if ($_SERVER["REMOTE_ADDR"] === "127.0.0.1")
{
	$trusted = true;
} else {
	// Check if caller is a Node
	$master = new Node();
	$nodelist = $master->getList(true);
	foreach ($nodelist as $node)
	{
		if ($_SERVER["REMOTE_ADDR"] === $node["attributes"]["IP"])
		{
			$trusted = true;
			break;
		}
	}

	// Check if caller is in 'trusted_hosts'
	if (!$trusted)
	{
		$hosts = $master->getTrustedHosts();
		if (in_array($_SERVER["REMOTE_ADDR"], $hosts)
			|| in_array($_SERVER["REMOTE_HOST"], $hosts)
			// TODO: correct this temporary check for avatar
			|| strpos($_SERVER["REMOTE_ADDR"], "10.8.0") == 0 || strpos($_SERVER["REMOTE_HOST"], "10.8.0") == 0)
		{
			$trusted = true;
		}
	}
}

if ($trusted == false)
{
	$response["error"] = "Forbidden";
	$response["code"] = 403;
} else {
	// Open temporary session for admin user
	// TODO: Implement separate private methods for internal calls
	//
	$sessionManager = new SessionManager();
	$sessionManager->login('admin', User::ADMIN);

	if (isset($_GET['function']))
	{
		$response = Proxy::call(array("API_GET"), $_GET["function"], $_GET);
	} else
	if (isset($_POST['function']))
	{
		$response = Proxy::call(array("API_POST"), $_POST["function"], $_POST);
	} else {
		$response["error"] = "Please specify 'function' parameter";
		$response["code"] = 404;
	}

	// Close session when response is ready
	//
	SessionManager::closeSession();
}

header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . "GMT");
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");

header('Content-type: application/json; charset=utf-8');
echo json_encode($response);
