<?php
/**
 * @version $Id: download.php 33135 2015-10-06 20:58:46Z sabaev $
 * ------------------------------------------------------------------------------
 * description
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */
session_start();

require_once $_SERVER["APL"] . "/api/lib/php/bootstrap.php";

// logic for getting events
if (isset($_GET['export_events']))
{
	if (!isset($_GET["start_time"]) || !isset($_GET["end_time"]) || !isset($_GET["role"]) || !isset($_SESSION[SESSION_USERID])) {
		header($_SERVER["SERVER_PROTOCOL"] . " 404 Not Found");
		echo "Wrong parameters";
	} 
	else {
		// parse parameters
		$userId = $_SESSION[SESSION_USERID];
		$user = new User();
		$username = $user->getName($userId);
		$roleId = $_GET["role"];
		$startTime = $_GET["start_time"]/1000;
		$endTime = $_GET["end_time"]/1000;
		
		// create request
		$qVars = array($userId, $roleId);
		
		$condition = ' AND extract(epoch from e.utc_when at time zone \'UTC\') >= ? AND extract(epoch from e.utc_when at time zone \'UTC\') <= ?';
		array_push($qVars, $startTime, $endTime);

		if(isset($_GET["search_pattern"])) {
			$condition.= " AND (e.message LIKE ? OR e.note LIKE ?)";
			array_push($qVars, "%".$_GET["search_pattern"]."%", "%".$_GET["search_pattern"]."%");
		}
		
		if(isset($_GET["event_type"])) {
			$condition.= " AND e.eventtype = ?";
			array_push($qVars, $_GET["event_type"]);
		}
		
		if(isset($_GET["event_state"])) {
			if(substr($_GET["event_state"], 0) == "!"){
				$condition.= " AND e.state != ?";
				array_push($qVars, substr($_GET["event_state"], 1));
			}
			else{
				$condition.= " AND e.state = ?";
				array_push($qVars, $_GET["event_state"]);
			}
		}
		
		$query =  
			"SELECT e.eventid, e.objid, obj.name AS obj_name, e.eventsource, src.name AS eventsource_name,".
				"utc_when, utc_from, utc_to, e.state, st.name AS state_name, message, note,". 
				"e.eventtype, typ.name AS eventtype_name, priority, pri.name AS priority_name".
			" FROM event e".
			" JOIN getObjects(?,?,null,null) obj ON obj.obj=e.objid AND obj.credentials LIKE '%v%'".
			" JOIN eventsource src ON src.eventsource=e.eventsource".
			" JOIN eventstate st ON st.eventstate=e.state".
			" JOIN eventtype typ ON typ.eventtype=e.eventtype".
			" JOIN eventpriority pri ON pri.eventpriority=e.priority".
			" WHERE 1=1".
				$condition.
			" ORDER BY e.eventid DESC".
			" LIMIT 1000 OFFSET 0";
		
		$result = DB::select($query, $qVars);

		$headers = array(
			__("Event ID"),
			__("Device ID"),
			__("Device name"),
			__("Source ID"),
			__("Source name"),
			__("Time When UTC"),
			__("Time From UTC"),
			__("Time To UTC"),
			__("State ID"),
			__("State name"),
			__("Message"),
			__("User note"),
			__("Type ID"),
			__("Type name"),
			__("Priority ID"),
			__("Priority name")
		);

		$out[0] = implode(",", $headers);

		// parse special fields
		for($i = 0; $i < count($result); $i++){
			$row = $result[$i];
			//note field
			if(!empty($row['note'])){
				$tmpNoteArray = json_decode($row['note'], true);
				$tmpNoteString = '"';
				for($j = 0; $j < count($tmpNoteArray); $j++){
					$tmpNoteString.= $tmpNoteArray[$j]['user'].":".$tmpNoteArray[$j]['note'];
					if($j != count($tmpNoteArray) - 1){
						$tmpNoteString.= "\n";
					}
				}
				$tmpNoteString.= '"';
				$row['note'] = $tmpNoteString;
			}
			// message field
			if(!empty($row['message'])){
				$row['message'] = '"'.$row['message'].'"';
			}
			$out[$i + 1] = implode(",", $row);
		}
		
		// assembly file name
		$marker = date(Template::convertStrDateFormatToPHPDateFormat(Identity::getAttribute("NLS_LONG_DATE_FORMAT"))."_".Template::convertStrTimeFormatToPHPTimeFormat(Identity::getAttribute("NLS_TIME_FORMAT")));
		$fileName = "event_export_{$username}_{$marker}.csv";
		
		$now = gmdate("D, d M Y H:i:s");
		
		// output headers
		header("Expires: Tue, 03 Jul 2001 06:00:00 GMT");
		header("Cache-Control: max-age=0, no-cache, must-revalidate, proxy-revalidate");
		header("Pragma: no-cache");
		header("Last-Modified: {$now} GMT");	
		header("Content-type: text/csv");	
		header("Content-Disposition: attachment; filename={$fileName}");

		// output data
		$outData = implode("\r\n", $out);
		echo $outData;
	}
	exit;
}

// logic for getting block associated with objects in _objs table
if (isset($_GET['obj']) && isset($_GET['blockId']))
{
	$obj = $_GET['obj'];
	$blockId = $_GET['blockId'];

	$object = Factory::getByObj($obj);
	$block = $object->getBlock($obj, $blockId);

	if (!isset($block["value"]))
	{
		header($_SERVER["SERVER_PROTOCOL"] . " 404 Not Found");

		print "Not found";

		exit;
	} else
	{
		// output headers
		header('Content-Disposition: attachment; filename="' . $block["name"] . '"');
		header('Content-type: ' . $block["mime"]);
		header("Content-Transfer-Encoding: binary");
		header("Content-Length: " . strlen($block["value"]));

		// output file content
		print $block["value"];
	}
}