#!/usr/bin/perl -w
# $Id: vctl.pl 26714 2012-09-05 14:52:33Z teetov $
# ------------------------------------------------------------------------------
#  Author: Alex Teetov
#  QA by:  Christopher C Gettings
#  Copyright: videoNEXT Network Solutions LLC
# ------------------------------------------------------------------------------
#  API call to access public version info
#
#  Usage: make a HTTP GET or POST request:
#       http://<URI>/api/cgi-bin/vctl.pl?retrun=info
#       http://<URI>/api/cgi-bin/vctl.pl?retrun=history
#
#  The call return XML document
# ------------------------------------------------------------------------------

use strict;
use CGI qw/escape unescape/;
use XML::Simple;
use Data::Dumper;

sub vctl {
# ----------------------------------------------------------- arguments
  my $request_method = $ENV{REQUEST_METHOD};
  my $form_info='';
  if ($ENV{REQUEST_METHOD} eq "GET") {
      $form_info = $ENV{QUERY_STRING};
  } else {
      my $size_of_form_information = $ENV{CONTENT_LENGTH};
      read (STDIN, $form_info, $size_of_form_information);
  }
  my %args=map{(uc($1),uc(unescape $2)) if /(\S+)=(.*)/} grep {/\S+=.*/} split /&/,$form_info;
# ----------------------------------------------------------- html header
  print <<XML;
Cache-Control: no-store, no-cache, must-revalidate
Cache-Control: post-check=0, pre-check=0
Pragma: no-cache
Content-Type: text/xml

<?xml version="1.0"?>
<!-- This XML provides Version Control information. RETURN=$args{RETURN} -->
XML

  my $result;
  if($args{RETURN} eq 'INFO' || $args{RETURN} eq 'HISTORY') {
      $result=processReturn($args{RETURN});
  }else {
      $result={'STATUS','ERROR','MESSAGE','No action specified'};
  }
  #print Dumper($result);
  print XMLout($result,rootname => 'RESULT');
}
             
# ---------------------------------------------------------- processReturn -----
sub processReturn {
    my $act=lc shift;
    my @version;
    my %result=('STATUS','OK');
    if(open RET,"$ENV{APL}/vpatch/bin/vctl $act|") {
       @version=<RET>;
       close RET; 
    } else {
       %result=('STATUS','ERROR','MESSAGE','Cannot get information from Version Control');
       return \%result;
    } 
    if($act eq 'info') {                                    # info 
       my %info= map {(uc($1),$2) if /^(\w+)=(.*)$/} grep {/^\w+=.*$/} @version;
       $result{INFO}={%info};
    } else {                                                # history
       my @token;
       foreach(@version) {
          push (@token, {'ACTION',$1,'DATE',$2}) if /^(\S+)\s+(.*)$/
       }
       $result{HISTORY}=[@token];
    }
    return \%result;
}

# MAIN -------------------------------------------------------------------------             
vctl;
# END_OF_FILE
