#!/usr/bin/perl
# $Id: hostinfo.cgi 28104 2013-03-12 16:51:03Z atsybulnik $
# ------------------------------------------------------------------------------
#  Author: Andrey Fomenko
#  Edited by: Kosta Kanchev, Serg Pososhenko
#  QA by:  Christopher C Gettings
#  Copyright: videoNEXT Network Solutions LLC
# ------------------------------------------------------------------------------
# 
#  API calls to accesst host parameters.
#
#  Usage: make a HTTP GET or POST request to http://<URI>/api/cgi-bin/hostinfo.cgi
#
#  Parameters:
#       return = (serno|version|supportfile|asrv|domain)
#
#           supportfile 	makes script stream out TGZ file with support info. 
#                       	HTTP POST type of request MUST be given for it.
#           serno	     	returns system serial number in XML
#           version		   	returns software version info in XML
#           asrv	      	returns host-specific parameters from $APL_CONF/asrv.conf 
#           runstate        return run state for engines
#           domain	    	returns other nodes registered in domain
#
# ------------------------------------------------------------------------------

use strict;
use NextCAM::Init; 
use NextCAM::WEBSession;
#use NextCAM::Common 'ReadPid';
use CGI qw/escape unescape/;
use URI::Escape;
use Data::Dumper;
use File::stat;

#----- Logger Initialize (use for report Backup / Restore in APP LOG page)
use Log::Log4perl "get_logger";
require "$ENV{APL}/common/bin/logger.audit";
my $device_log = get_logger('APACHE.AUDIT.DEVICE_MANAGEMENT');

# ------------=== CGI parametyers processing into "%args" hash ===--------------
my $request_method = $ENV{REQUEST_METHOD};
my $form_info='';
if ($ENV{REQUEST_METHOD} eq "GET") {
      $form_info = $ENV{QUERY_STRING};
} else {
      my $size_of_form_information = $ENV{CONTENT_LENGTH};
      read (STDIN, $form_info, $size_of_form_information);
}

my %args;
my $action;
my $message;
my $err=0;
my $db_error=0;
my @lines;
my %conf = GetCfgs(('DEVICETYPE'=>'NEXTCAM'));
my %asrv = GetAsrv();
my ($APL, $APL_CONF, $APL_VAR)=($ENV{APL},$ENV{APL_CONF},$ENV{APL_VAR});
my $CONFDIR= $APL.'/var/conf';
# network files to backup (file => file's dir)
my %NET_FILES = (
	'network'    => '/etc/sysconfig/',
    'ifcfg-eth*' => '/etc/sysconfig/network-scripts/',
    '.htaccess'  => '$APL/sg/html/'
);

foreach(split /&/,$form_info){ $args{uc($1)} = unescape($2) if(/(\S+)=(\S+)/) }

# Get Web session attributes
my $sinfo = WEBSessionAttr($args{SID}, 1, 1);

# ---------------------------------XMLHeader------------------------------------

sub XMLHeader {
print <<XML;
Cache-Control: no-store, no-cache, must-revalidate
Cache-Control: post-check=0, pre-check=0
Pragma: no-cache
Content-Type: text/xml

<?xml version="1.0"?>
XML
}#XMLHeader

# ---------------------------------Main loop------------------------------------

unless($sinfo) {
    $err = 1;
    $message = "Operation not allowed";
    printLines();
    exit;
}

my $SID = $sinfo->{sid};
my $WebUserID = $sinfo->{userid};
my $WebUserName = $sinfo->{username};

eval {
        if($args{RETURN}=~/ASRV/i) {
			$action = "OK";
            processAsrv();
        }
        if($args{RETURN}=~/RUNSTATE/i) {
			$action = "OK";
            processRunstate();
        }
        if($args{RETURN}=~/SERNO/i) {
			$action = "OK";
            processSerial();
        }
        if($args{RETURN}=~/VERSION/i) {
			$action = "OK";
            processVersion();
        }
        if($args{RETURN}=~/DOMAIN/i) {
			$action = "OK";
            processDomain();
		}
};

if($action){
	printLines();
} else {
	$err = 1;
	$message = "No action specified";
	printLines();
}
exit;



# --------------------------------processAsrv-----------------------------------

sub processAsrv {
	push @lines, '    <ASRV>';
    foreach my $key ( sort keys %asrv) {
        push @lines, "<$key VALUE=\"".uri_escape($asrv{$key})."\"/>";
    }
    push @lines, "<DB_TYPE VALUE=\"$ENV{APL_DB_TYPE}\"/>" if defined($ENV{APL_DB_TYPE});
    push @lines, "<DB_CONNECT_STRING VALUE=\"$ENV{APL_DB_CONNECT_STRING}\"/>" if defined($ENV{APL_DB_CONNECT_STRING});
    push @lines, '    </ASRV>';

} # sub processAsrv

# ------------------------------processRunstate---------------------------------
sub processRunstate {
    # Read cam_patrol status from shepherd's status file
    my $status;
    eval {
	if ($^O !~ /darwin/i) {
	    open STATUS,"$APL_VAR/wd/status" or die "Failed to read status: $!\n";
	    $status = <STATUS>;
	    close STATUS;
	    chomp $status;
	    die "No status in file\n" unless $status;
	    $status = $status=~/^run/?'ONLINE':'OFFLINE';
	}
	else {
	    my ($run) = `$APL/sly/darwin/bin/control status`=~/^running: (.+)$/im;
	    $status = $run eq 'yes' ? 'ONLINE' : 'OFFLINE';
	}
    };
    if ( $@ ) {
	chomp $@;
	$err++;
	$message = $@;
	return;
    }
    push @lines, "\t<DAEMONS>";
    push @lines, "\t\t<CAM_PATROL STATUS=\"$status\"/>"; 
    push @lines, "\t</DAEMONS>";
} # sub processRunstate


# ------------------------------processSerial-----------------------------------

sub processSerial {
    my $serno = `$ENV{APL}/db/bin/db_exec -t -c "SELECT val FROM _obj_attr WHERE attr='SERIAL_NO' AND obj=53;" skm_master`;
    $serno=~s/\s//gi;
    if($serno) {
        push @lines, "    <SERNO VALUE=\"$serno\"/>";
    }
    else {
        push @lines, "    <SERNO VALUE=\"undefined\"/>";
        $err=1;
    }

} #sub processSerial

# ------------------------------processVersion---------------------------------

sub processVersion {   # looks like 2.4.1-int20070627_1
    if(open VER,"$APL/base/etc/VERSION") {
        $_=<VER>;  
        close VER;
        if (/^(\d+\.\d+\.\d)-(\w+)_(\d+)$/) {
           push @lines, "    <VERSION VALUE=\"$1\" STAGE=\"$2\" BUILD=\"$3\" LONG=\"$_\" />"
        } else {
          $err=1;
          push @lines, "    <VERSION VALUE=\"undefined\"/>";
        }
    } else {
        $err=1;
        push @lines, "    <VERSION VALUE=\"undefined\"/>";
    }
} # sub processVersion

# ------------------------------processDomain---------------------------------

sub processDomain {

use Master::Conf; 
#use Data::Dumper; 
my $a=NodeList; 

	push @lines, "    <DOMAIN>";
#    push @lines, Dumper($a);
    foreach my $node (keys %$a) {
		push @lines, "<NODE UNI=\"$a->{$node}{UNI}\" HOST=\"$a->{$node}{FQDN}\" IP=\"$a->{$node}{IP}\" VERID=\"$a->{$node}{VERID}\" RTSP_PORT=\"$a->{$node}{RTSP_PORT}\" LAN_IP=\"$a->{$node}{IP}\" WAN_IP=\"$a->{$node}{IP}\"/>";
	}
	push @lines, "    </DOMAIN>";


} # sub processDomain


# -------------------------------printLines-----------------------------------

sub printLines {
	XMLHeader();
	print "<RESULT>\n";
	if($message) {
		print "\t<STATUS VALUE=\"".($err?"ERROR" : "OK"). "\" MESSAGE=\"".$message.$db_error."\"/>\n";
	} else {
		print "\t<STATUS VALUE=\"".($err?"ERROR" : "OK"). "\" MESSAGE=\"".$db_error."\"/>\n";
	}
	foreach (@lines) {
		print "$_\n";
	}
	
	print "</RESULT>\n";
	exit 0;
} #sub printLines

