#!/usr/bin/perl
# $Id: filedirect.cgi 28104 2013-03-12 16:51:03Z atsybulnik $
# ------------------------------------------------------------------------------
#  Author: Andrey Fomenko
#  Edited by: 
#  QA by:  Christopher C Gettings
#  Copyright: videoNEXT Network Solutions LLC
# ------------------------------------------------------------------------------
#  API calls to accesst configuration files directly. 
#  Allows both read and write access.
#
#  Usage: make a HTTP GET or POST request to http://<URI>/api/cgi-bin/filedirect.cgi
#
#  Parameters:
#   operation   [get|put]
#   file        filename [with extentions if any]
#   devid       XX
#   content     file-content (send with HTTP POST)
#
#  If "devid" parameter provided, both "get" and "put" operations are permitted.
#  Configuration file will be addressed in $APL_CONF/<devid>/ directory.
#  If "devid" parameter ommitted, only "get" operation permitted, and file will
#  be addressed in $APL_CONF directory.
#
# ------------------------------------------------------------------------------

use strict;
use CGI qw/escape unescape/;
use NextCAM::WEBSession;
use SKM::DB;

# Let's get all parameters from request

my $request_method = $ENV{REQUEST_METHOD};
my $form_info='';
if ($ENV{REQUEST_METHOD} eq "GET") {
      $form_info = $ENV{QUERY_STRING};
} else {
      my $size_of_form_information = $ENV{CONTENT_LENGTH};
      read (STDIN, $form_info, $size_of_form_information);
}

my %args;
foreach(split /&/,$form_info){ $args{uc($1)} = unescape($2) if(/(\S+)=(\S+)/) }

# Protection against code injection
filterMetaChars($args{DEVID});
filterMetaChars($args{FILE});

my @ANALYTICS_CONF = ('analytics.xml','behavior.conf','fpssparams2.conf','gmuparams2.conf');
my $RE = '^('.join('|',@ANALYTICS_CONF).')$';
# ------------------------ Check session -----------------------------------
# Only users that can access Admin GUI are permitted to use this API
my ($SID, $WebUserID, $WebUserName);
my $sinfo = WEBSessionAttr($args{SID}, 1, 1);
if ($sinfo) {
    $SID = $sinfo->{sid};
    $WebUserID = $sinfo->{userid};
    $WebUserName = $sinfo->{username};
}

my $HDR = <<END;
Cache-Control: no-store, no-cache, must-revalidate
Cache-Control: post-check=0, pre-check=0
Pragma: no-cache
Content-Type: text/html

END

# Only authorized requests allowed
unless($SID) {
    err("Operation not allowed!");
}

# Validate arguments
if (!$args{OPERATION} || !$args{FILE}) {
    err("You have to provide paramaters 'OPERATION' and FILE'' for your request!");
}

# Cannot mofify files outside of device dirs
if (uc($args{OPERATION}) eq 'PUT' && !$args{DEVID}) {
    err("It is forbidden to modify template configuration files!");
}

# File name cannot contain '/' char
if ($args{FILE}=~/\//) {
    err("You can not address non-default directries with this call!");
}

my $fname = $ENV{APL_CONF}.'/';
$fname .= "$args{DEVID}/" if $args{DEVID};
$fname .= $args{FILE};

if (uc($args{OPERATION}) eq 'GET') {
    print <<ENDOFXML;
Cache-Control: no-store, no-cache, must-revalidate
Cache-Control: post-check=0, pre-check=0
Pragma: no-cache
Content-Type: text/xml

ENDOFXML

    open F, $fname;
    print while <F>;
    close F;
}
elsif (uc($args{OPERATION}) eq 'PUT') {
    # Save analytics configs to obj_block
    if ($args{FILE} =~ /$RE/) {
	eval {
	    my $dbm = DBMaster({RaiseError => 1, PrintError => 0});
	    my $ra = $dbm->selectall_arrayref("SELECT blockid FROM obj_block WHERE obj=$args{DEVID} AND name='$args{FILE}'");
	    if (@$ra) { # Block already exists
		$dbm->do("UPDATE obj_block SET block='$args{CONTENT}' WHERE obj=$args{DEVID} AND name='$args{FILE}'");
	    }
	    else {
		$dbm->do(
		    "INSERT INTO obj_block (obj,name,mime,block) 
		    VALUES ($args{DEVID},'$args{FILE}','text/xml','$args{CONTENT}')"
		);
	    }
	    $dbm->disconnect;
	};
	if ($@) {
	    err("DB Error when saving analytics data!");
	}
    }
    open F, ">$fname";
    print F $args{CONTENT};
    close F;
    print $HDR;
}

# ----------------------------------------------------------- filterMetaChars --------------
sub filterMetaChars {
    my $meta = "][<>\|&;`'\"*\$\?~\^(){}\n\r";
    $_[0] =~ s/([$meta])//g;
}

sub err {
    my $msg = shift;
    print <<ENDOFHTML;
$HDR
<HTML>
<BODY>
$msg
</BODY>
</HTML>
ENDOFHTML
    exit;
}
