#!/usr/bin/perl -w
# ------------------------------------------------------------------------------
#  Author: Serg Pososhenko
#  Edited by: 
#  QA by:  Christopher C Gettings
#  Copyright: videoNEXT Network Solutions LLC
# ------------------------------------------------------------------------------
#  API call to access Dynamic data.
#
#  Usage: make a HTTP GET or POST request to http://<URI>/api/cgi-bin/dynadata.cgi
#
#  Parameters: 
#   return=[datatypes|datablock|blockids]       optional
#   modify=[datatypes|datablock]                optional
#   <contentID>=<value>                         mandatory parameter for modify=datablock requests where datatypes get REQUIRED=yes
#   <datatypes>=<value>                         mandatory parameter for modify=datablock requests 
#   <operation>=[new|delete]                    mandatory parameter for modify=datatypes requests optional for modify=datablock
# ------------------------------------------------------------------------------

use strict;
use SKM::DB;
use CGI qw/escape unescape/;
use Time::Local;
use NextCAM::WEBSession;


# Let's get all parameters from request
my $APLUSR='apl';
my $request_method = $ENV{REQUEST_METHOD};
my $form_info='';
if ($ENV{REQUEST_METHOD} eq "GET") {
      $form_info = $ENV{QUERY_STRING};
} elsif ($ENV{REQUEST_METHOD} eq "POST"){
      my $size_of_form_information = $ENV{CONTENT_LENGTH};
      read (STDIN, $form_info, $size_of_form_information);
}else{
    $form_info = $ARGV[0];
}


my %args;
foreach(split /&/,$form_info){ $args{uc($1)} = unescape($2) if /(\S+)=(.*)/ }


my ($SID, $WebUserID, $WebUserName);
my $sinfo = WEBSessionAttr($args{SID}, 1, 1);
if ($sinfo) {
    $SID = $sinfo->{sid};
    $WebUserID = $sinfo->{userid};
    $WebUserName = $sinfo->{username};
}

# ------------------------------------------------------------------------------

use Log::Log4perl "get_logger";
require "$ENV{APL}/common/bin/logger.audit";
my $log = get_logger('APACHE.AUDIT.DEVICE_MANAGEMENT');   
 
print <<XML;
Cache-Control: no-store, no-cache, must-revalidate
Cache-Control: post-check=0, pre-check=0
Pragma: no-cache
Content-Type: text/xml

<?xml version="1.0"?>
XML

# Check permissions
unless($SID) {
    print "<DYNADATA>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Operation not allowed\"/>\n</DYNADATA>\n";;
    exit 0;
}

use NextCAM::Init;
my ($APL, $APL_CONF)=($ENV{APL},$ENV{APL_CONF});


my ( $device, $updMsg, $updValues );

if($args{RETURN}) { ###########################################################
    processReturn();
} # if($args{RETURN})
elsif($args{MODIFY}) { ########################################################
    processModify();
} # if($args{MODIFY})
else {
    print "<DYNADATA>\n<STATUS VALUE=\"OK\" MESSAGE=\"No action specified\"/>\n</DYNADATA>\n";
}
exit 0; 

    
# ---------------------------------------------------------- processReturn -----
sub processReturn {

    if ($args{RETURN}=~/DATATYPES/i) { # <======================== DATATYPES =====
        returnDataTypes();
    }
    if ($args{RETURN}=~/DATABLOCK/i) { # <======================== DATABLOCK =====
        returnDataBlock();
    }
    if ($args{RETURN}=~/BLOCKIDS/i) { # <================================ BLOCKIDS =====
        returnBlockIDS();
    }
} # sub processReturn

# ---------------------------------------------------------- processModify -----
sub processModify {

    if ($args{MODIFY}=~/DATATYPES/i) { # <======================== DATATYPES =====
        modifyDataTypes();
    }
    if ($args{MODIFY}=~/DATABLOCK/i) { # <======================== DATABLOCK =====
        modifyDataBlock();
    }

} # sub processModify

#===========================================returnDataTypes===========================================================
sub returnDataTypes {
    my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);
    my $dbreturns=($dbh->selectall_hashref('select * from dyna_types','typeid'));
  if (!$dbreturns)
        {
          print "<DYNADATA>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"DB access error\"/>\n</DYNADATA>\n";
          $log->logdie($DBI::errstr);
        }
    $dbh->disconnect();
    my $ee = scalar(%$dbreturns);
    if ($ee ne 0)
    {
      print "<DYNADATA>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Query successful\"/>\n";

      foreach my $dbrow ( keys %$dbreturns ) 
      {
        print "\t<DATATYPE TYPEID=\"$dbreturns->{$dbrow}{typeid}\" SCOPE=\"$dbreturns->{$dbrow}{scope}\" REQUIRED=\"$dbreturns->{$dbrow}{requireid}\"/>\n";
      }
      print "</DYNADATA>\n";     
    }
    else
    {
          print "<DYNADATA>\n<STATUS VALUE=\"OK\" MESSAGE=\"No one DataTypes registred\"/>\n</DYNADATA>\n";
    }
}

#===========================================returnBlockIDS===========================================================
sub returnBlockIDS {
  my $query='';
  my $request='';
  if ((defined($args{TYPEID}))&&(defined($args{CONTENTID})))
  {
    $query = "SELECT ind,description from dyna_data where typeid='".$args{TYPEID}."' and contentid='".$args{CONTENTID}."'";
  }
  elsif((defined($args{TYPEID})))
  {
    $query = "SELECT ind,description from dyna_data where typeid='".$args{TYPEID}."'";
  }
  else
  {
    $query = "SELECT * from dyna_data";
    $request='all';
  }
  if ($query)
  {
    my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);
    my $dbreturns=$dbh->selectall_hashref($query, 'ind');
    if (!$dbreturns)
    {
      print "<DYNADATA>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"DB access error\"/>\n</DYNADATA>\n";
      $log->logdie($DBI::errstr);
    }
    $dbh->disconnect();
    my $ee = scalar(%$dbreturns);
    if ($ee ne 0)
#    if (scalar(%$dbreturns) != 0)
    {
      print "<DYNADATA>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Query successful\"/>\n";

      foreach my $dbrow ( keys %$dbreturns ) 
      {
        if ($request eq 'all')
        {
          print "\t<DATABLOCK BLOCKID=\"$dbreturns->{$dbrow}{ind}\" TYPEID=\"$dbreturns->{$dbrow}{typeid}\" DESCRIPTION=\"$dbreturns->{$dbrow}{description}\"/>\n";
        }
        else{ print "\t<DATABLOCK BLOCKID=\"$dbreturns->{$dbrow}{ind}\" TYPEID=\"$args{TYPEID}\" DESCRIPTION=\"$dbreturns->{$dbrow}{description}\"/>\n";}
      }
      print "</DYNADATA>\n";     
    }
    else
    {
          print "<DYNADATA>\n<STATUS VALUE=\"OK\" MESSAGE=\"No one DataTypes registred\"/>\n</DYNADATA>\n";
    }
  }
}

#===========================================returnDataBlock===========================================================
sub returnDataBlock {
  my $query='';
  my $request='';
  if ((defined($args{BLOCKID})))
  {
    $query = "SELECT * from dyna_data where ind='".$args{BLOCKID}."'";
  }
  elsif ((defined($args{TYPEID}))&&(defined($args{CONTENTID})))
  {
    $query = "SELECT * from dyna_data where typeid='".$args{TYPEID}."' and contentid='".$args{CONTENTID}."'";
  }
  elsif((defined($args{TYPEID})))
  {
    $query = "SELECT * from dyna_data where typeid='".$args{TYPEID}."'";
  }
  elsif((defined($args{CONTENTID})))
  {
    $query = "SELECT * from dyna_data where contentid='".$args{CONTENTID}."'";
  }
  else
  {
    $query = "SELECT * from dyna_data";
  }
  if ($query)
  {
    my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);
    my $dbreturns=$dbh->selectall_hashref($query, 'ind');
    if (!$dbreturns)
    {
      print "<DYNADATA>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"DB access error\"/>\n</DYNADATA>\n";
      $log->logdie($DBI::errstr);
    }
    $dbh->disconnect();

    my $ee = scalar(%$dbreturns);
    if ($ee ne 0)    
#    if (scalar(%$dbreturns) != 0)
    {
      print "<DYNADATA>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Query successful\"/>\n";

      foreach my $dbrow ( keys %$dbreturns ) 
      {
		print "\t<DATABLOCK BLOCKID=\"$dbreturns->{$dbrow}{ind}\" ";
		if (defined($dbreturns->{$dbrow}{typeid})){
			print " TYPEID=\"$dbreturns->{$dbrow}{typeid}\" ";
		}else { print " TYPEID=\"\" ";}
		if (defined($dbreturns->{$dbrow}{contentid})){
			print " CONTENTID=\"$dbreturns->{$dbrow}{contentid}\" ";
		}else { print " CONTENTID=\"\" ";}
		if (defined($dbreturns->{$dbrow}{description})){
			print " DESCRIPTION=\"$dbreturns->{$dbrow}{description}\" ";
		}else { print " DESCRIPTION=\"\" ";}
		print ">\n";
		print "\t\t<LAYOUT>$dbreturns->{$dbrow}{data}</LAYOUT>\n\t</DATABLOCK>\n";
      }
      print "</DYNADATA>\n";     
    }
    else
    {
          print "<DYNADATA>\n<STATUS VALUE=\"OK\" MESSAGE=\"No one Dynamic Data block exist\"/>\n</DYNADATA>\n";
    }
  }
}

#===========================================modifyDataTypes===========================================================
sub modifyDataTypes {
  if($args{OPERATION}=~/NEW/i ) 
  {

    if ((defined($args{TYPEID}))&&(defined($args{SCOPE}))&&(defined($args{REQUIRED}))&&(defined($args{UNIQUE}))&&(defined($args{BACKUP})))
    {
      my $query = "insert into dyna_types select '".$args{TYPEID}."', '".$args{SCOPE}."', '".$args{REQUIRED}."', '".$args{UNIQUE}."','','".$args{BACKUP}."'";
      my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);
      my $rows=$dbh->do($query);
      $dbh->disconnect();
      if ($rows == 1)
      {
        print "<DYNADATA>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Dynamic data type added successfully\"/>\n";
        print "\t<DATATYPE TYPEID=\"$args{TYPEID}\" SCOPE=\"$args{SCOPE}\" REQUIRED=\"$args{REQUIRED}\" UNIQUE=\"$args{UNIQUE}\" BACKUP=\"$args{BACKUP}\"/>\n";
        print "</DYNADATA>\n";
      }
      else
      {
        print "<DYNADATA>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Dynamic data insert error.\"/>\n</DYNADATA>\n";
      }
    }
    else
    {
      print "<DYNADATA>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Insufficient list of arguments\"/>\n</DYNADATA>\n";      
    }
  }
    if($args{OPERATION}=~/DELETE/i ) 
  {
    if ((defined($args{TYPEID})))
    {
      my $query = "delete from dyna_types where typeid='".$args{TYPEID}."'";
      my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);
      my $rows=$dbh->do($query);
      $dbh->disconnect();
      if ($rows == 1)
      {
        print "<DYNADATA>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Dynamic data type deleted successfully\"/>\n</DYNADATA>\n";
      }
      else
      {
        print "<DYNADATA>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Dynamic data delete error\"/>\n</DYNADATA>\n";
      }
    }
    else
    {
      print "<DYNADATA>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Insufficient list of arguments\"/>\n</DYNADATA>\n";      
    }
  } 
}

#===========================================modifyDataBlock===========================================================
sub modifyDataBlock {
  if(!$args{OPERATION}) 
  {
    my $query='';
    if ((defined($args{BLOCKID}))&&($args{BLOCKID} ne 'new')&&(defined($args{DATA}))&&(defined($args{CONTENTID})))
    {
      if (defined($args{DESCRIPTION})){
        $query = "update dyna_data set data='$args{DATA}', description='$args{DESCRIPTION}', contentid='$args{CONTENTID}' WHERE ind='$args{BLOCKID}'";
      }else{
        $query = "update dyna_data set data='$args{DATA}', contentid='$args{CONTENTID}' WHERE ind='$args{BLOCKID}'";
      }
    }
    elsif ((defined($args{BLOCKID}))&&($args{BLOCKID} ne 'new')&&(defined($args{DATA})))
    {
      if (defined($args{DESCRIPTION})){
        $query = "update dyna_data set data='".$args{DATA}."', description='".$args{DESCRIPTION}."' WHERE ind='".$args{BLOCKID}."'";
      }else{
        $query = "update dyna_data set data='".$args{DATA}."' WHERE ind='".$args{BLOCKID}."'";
      }
    }
    elsif ((defined($args{BLOCKID}))&&($args{BLOCKID} eq 'new')&&(defined($args{TYPEID}))&&(defined($args{CONTENTID}))&&(defined($args{DATA})))
    {
      if (defined($args{DESCRIPTION})){
        $query = "insert into dyna_data (typeid, contentid, data, description ) VALUES ('$args{TYPEID}', '$args{CONTENTID}', '$args{DATA}', '$args{DESCRIPTION}')";
      }else{
        $query = "insert into dyna_data (typeid, contentid, data) VALUES ('$args{TYPEID}', '$args{CONTENTID}', '$args{DATA}')";
      }
    }
    elsif ((defined($args{BLOCKID}))&&($args{BLOCKID} eq 'new')&&(defined($args{TYPEID}))&&(defined($args{DATA})))
    {
      if (defined($args{DESCRIPTION})){
        $query = "insert into dyna_data (typeid, data, description) VALUES ('$args{TYPEID}', '$args{DATA}', '$args{DESCRIPTION}')";
      }else{
        $query = "insert into dyna_data (typeid, data) VALUES ('$args{TYPEID}', '$args{DATA}')";
      }
    }
    else
    {
      print "<DYNADATA>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Insufficient list of arguments\"/>\n</DYNADATA>\n";      
    }
    if($query)#===========================================update/insert===================================================
    {
      my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);
      if ($args{BLOCKID} eq 'new')
      {
        my @row_dyna_types = $dbh->selectrow_array("select * from dyna_types where typeid='$args{TYPEID}'");
        if ($row_dyna_types[3])
        {
          my @row_dyna_data = $dbh->selectrow_array("select * from dyna_data where typeid='$args{TYPEID}'");
          if (scalar(@row_dyna_data))
          {
            $dbh->disconnect();
            print "<DYNADATA>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Data restriction\"/>\n</DYNADATA>\n";
            return 0;
          }
        }
        if ($row_dyna_types[2])
        {
          if(!$args{CONTENTID})
          {
            $dbh->disconnect();
            print "<DYNADATA>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Data restriction\"/>\n</DYNADATA>\n";
            return 0;
          }
        }
      }
      my $rows=$dbh->do($query);
      if ($rows == 1)
      {
        if ((defined($args{BLOCKID}))&&($args{BLOCKID} ne 'new')&&(defined($args{DATA})))
        {
          $query = "SELECT ind from dyna_data WHERE ind='".$args{BLOCKID}."'";
        }
         elsif ((defined($args{BLOCKID}))&&($args{BLOCKID} eq 'new')&&(defined($args{TYPEID}))&&(defined($args{CONTENTID}))&&(defined($args{DATA})))
        {
          $query = "SELECT ind from dyna_data where typeid='".$args{TYPEID}."' and data='".$args{DATA}."' and contentid='".$args{CONTENTID}."'";
        }
        elsif ((defined($args{BLOCKID}))&&($args{BLOCKID} eq 'new')&&(defined($args{TYPEID}))&&(defined($args{DATA})))
        {
          $query = "SELECT ind from dyna_data where typeid='".$args{TYPEID}."' and data='".$args{DATA}."'";
        }
        my $dbreturns=$dbh->selectall_hashref($query, 'ind');
        if (!$dbreturns)
        {
          print "<DYNADATA>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"DB access error\"/>\n</DYNADATA>\n";
          $log->logdie($DBI::errstr);
        }
        $dbh->disconnect();
        my $ee = scalar(%$dbreturns);
        if ($ee ne 0)
#        if (scalar(%$dbreturns) != 0)
        {
          print "<DYNADATA>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Query successful\"/>\n";
    
          foreach my $dbrow ( keys %$dbreturns ) 
          {
            print "\t<DATABLOCK BLOCKID=\"$dbreturns->{$dbrow}{ind}\"/>\n";
          }
          print "</DYNADATA>\n"; 
              
          restartEngine($args{TYPEID});
        }
        else
        {
              print "<DYNADATA>\n<STATUS VALUE=\"OK\" MESSAGE=\"No one DataTypes registred\"/>\n</DYNADATA>\n";
        }
      }
      else
      {
        $dbh->disconnect();
        print "<DYNADATA>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Dynamic data insert error\"/>\n</DYNADATA>\n";
      }
    }#===========================================end update/insert===================================================
  }
    if((defined($args{OPERATION}))&&($args{OPERATION}=~/DELETE/i ))
  {
    if ((defined($args{BLOCKID})))
    {
      my $query = "DELETE from dyna_data WHERE ind='".$args{BLOCKID}."'";
      my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);
      my $rows=$dbh->do($query);
      $dbh->disconnect();
      if ($rows == 1)
      {
        print "<DYNADATA>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Delete request successful\"/>\n";
        print "\t<DATABLOCK BLOCKID=\"$args{BLOCKID}\"/>\n";
        print "</DYNADATA>\n";  
      }
      else
      {
        print "<DYNADATA>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Dynamic data DATA delete error\"/>\n</DYNADATA>\n";
      }
    }
    else
    {
      print "<DYNADATA>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Insufficient list of arguments\"/>\n</DYNADATA>\n";      
    }
  }
}
#===========================================end===========================================================

#===========================================restartEngine===========================================================
sub restartEngine 
{
  my $typeid=shift;
  my $query = "select restartcmd from dyna_types WHERE typeid='".$typeid."'";
  my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);
  my @row_dyna_types = $dbh->selectrow_array($query);
  if ($row_dyna_types[0] ne '')
  {
    system("sudo -u $APLUSR $row_dyna_types[0]"); #sudo has to be configured to start $row_dyna_types[0] by apache
  }
  $dbh->disconnect(); 


}