#!/usr/bin/perl -w
#  $Id: crdmng.cgi 28104 2013-03-12 16:51:03Z atsybulnik $
# ------------------------------------------------------------------------------
#  Author: Serg Pososhenko
#  Edited by: Andriy Fomenko
#  QA by:  Christopher C Gettings
#  Copyright: videoNEXT Network Solutions LLC
# ------------------------------------------------------------------------------
#  API call to get credentions.
#
#  Usage: make a HTTP GET or POST request to http://<URI>/api/cgi-bin/crdmng.cgi
#
#  Parameters:
#   return=
#           whoami          return user id or name from the session
#								additional pameters:
#
#									attr=id/name
#                                   sid="PHP SESSION ID", if cookies aren't included in the request
#   modify=
# ------------------------------------------------------------------------------

use strict;
use SKM::DB;
use CGI qw/escape unescape/;
use Time::Local;
use XML::Simple;
use Data::Dumper;
use URI::Escape;
use NextCAM::WEBSession;
use LWP::Simple qw($ua get);
$ua->timeout(10);            # even 10 seconds may cause the problem..
$ua->agent('skm agent/2.5'); # fancy agent info

# Let's get all parameters from request
my $APLUSR='apl';
my $request_method = $ENV{REQUEST_METHOD};
my $form_info='';
my $err_message='';
if ($ENV{REQUEST_METHOD} eq "GET") {
      $form_info = $ENV{QUERY_STRING};
} else {
      my $size_of_form_information = $ENV{CONTENT_LENGTH};
      read (STDIN, $form_info, $size_of_form_information);
}

my %args;
foreach(split /&/,$form_info){ $args{uc($1)} = unescape($2) if /(\S+)=(.*)/ }

#-------------------------------------------------------------------------------
# Session attributes

my ($SID, $WebUserID, $WebUserName);
my $sinfo = WEBSessionAttr($args{SID}, 1, 1);
if ($sinfo) {
    $SID = $sinfo->{sid};
    $WebUserID = $sinfo->{userid};
    $WebUserName = $sinfo->{username};
}

# ------------------------------------------------------------------------------

use Log::Log4perl "get_logger";
require "$ENV{APL}/common/bin/logger.audit";
my $log = get_logger('APACHE.AUDIT.DEVICE_MANAGEMENT');
my $u_log = get_logger('APACHE.AUDIT.USER_MANAGEMENT');

print <<XML;
Cache-Control: no-store, no-cache, must-revalidate
Cache-Control: post-check=0, pre-check=0
Pragma: no-cache
Content-Type: text/xml

<?xml version="1.0"?>
XML

use NextCAM::Init;
my ($APL, $APL_CONF)=($ENV{APL},$ENV{APL_CONF});
my $message;

if($args{RETURN}) { ###########################################################
    # Check permissions
    unless($SID) {
	print "<RESULT>\n<STATUS VALUE=\"ERROR\" MESSAGE=\"Operation not allowed\"/>\n</RESULT>\n";
	exit 0;
    }
    if (processReturn())
    {exit 1;}
    else
    {
            print "<RESULT>\n<STATUS VALUE=\"ERROR\" MESSAGE=\"Can't process your request\"/>\n</RESULT>\n";
            exit 0;
    }

} # if($args{RETURN})
elsif($args{MODIFY}) { ########################################################
    # Check permissions
    unless($SID) {
	print "<RESULT>\n<STATUS VALUE=\"ERROR\" MESSAGE=\"Operation not allowed\"/>\n</RESULT>\n";
	exit 0;
    }
    if(processModify())
        {exit 1;}
    else
    {
            print "<RESULT>\n<STATUS VALUE=\"ERROR\" MESSAGE=\"Can't process your request\"/>\n</RESULT>\n";
            exit 0;
    }

} # if($args{MODIFY})
else {
    print "<RESULT>\n<STATUS VALUE=\"OK\" MESSAGE=\"No action specified\"/>\n</RESULT>\n";
}
exit 0;



# ----------------------------------------------------------------- my_log (mylog) -----
sub my_log
{
	my $msg = shift;
	#`echo $msg >> /tmp/log.log`;
	open(F, ">> /tmp/log.log");
	print(F "$msg\n");
	close(F);
}

# ----------------------------------------------------------------- escXML -----

sub escXML {
    $_ = shift;
    s/&/&amp;/g;
    s/</&lt;/g;
    s/>/&gt;/g;
    s/'/&apos;/g;
    s/"/&quot;/g;
    s/%26/&amp;/g;
    s/%3c/&lt;/gi;
    s/%3e/&gt;/gi;
    s/%22/&quot;/g;
    s/%27/&apos;/g;
    return $_;
} # sub escXML'

# ---------------------------------------------------------- processReturn -----
sub processReturn {
    if ($args{RETURN}=~/OTYPES/i) {
        returnOTypes();
    }elsif($args{RETURN}=~/LINKTYPES/i){
      returnLinkTypes();
    }elsif($args{RETURN}=~/USERCREDENTIALS/i){
      retUserCredentials();
    }elsif($args{RETURN}=~/CREDENTIALS/i){
      potentialCred();
    }elsif($args{RETURN}=~/RESOURCELIST/i){
      returnResourceList();
    }elsif($args{RETURN}=~/RESOURCEINFO/i){
      returnResourceInfo();
    }elsif($args{RETURN}=~/SETINFO/i){
      returnSetInfo();
    }elsif($args{RETURN}=~/SETLIST/i){
      returnSetList();
    }elsif($args{RETURN}=~/ROLELIST/i){
      returnRoleList();
    }elsif($args{RETURN}=~/ROLEINFO/i){
      returnRoleInfo();
    }elsif($args{RETURN}=~/USERLIST/i){
      returnUserList();
    }elsif($args{RETURN}=~/USERINFO/i){
      returnUserInfo();
    }elsif($args{RETURN}=~/TRANSL/i){
      returnTransl();
    }elsif($args{RETURN}=~/WHOAMI/i) {
      returnWhoAmI();
    }else{return 0;}

} # sub processReturn

# ---------------------------------------------------------- processModify -----
sub processModify {

    if ($args{MODIFY}=~/REFRESHRESOURCES/i) { # <======================== DATATYPES =====
        refreshresources();

    }
    elsif ($args{MODIFY}=~/SET/i) { # <======================== SETS =====
        modifySet();
    }
    elsif ($args{MODIFY}=~/ROLE/i) { # <======================== ROLE =====
        modifyRole();
    }
    elsif ($args{MODIFY}=~/USER/i) { # <======================== ROLE =====
        modifyUser();
    }
    elsif ($args{MODIFY}=~/LINK/i) {
      modifyLink();
    }else{return 0;}
} # sub processModify

# ---------------------------------------------------------- potentialCred -----
sub potentialCred {
  my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);
  if((defined($args{ROLE_ID})) and (!defined($args{SET_ID})))
  {
    my $query = "select obj from _objs where obj=? and otype='R'";
#    print "$query\n";
    my $sth=$dbh->prepare($query);
    my $rv=$sth->execute($args{ROLE_ID});
    if ($rv eq '0E0')
    {
      print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Object ID=$args{ROLE_ID} is not a ROLE type\"/>\n</RESULT>\n";
    }
    else
    {
      $query = "select obj_res from _links where obj_cons=? and link_type='S2R'";#$args{OBJ}
      $sth=$dbh->prepare($query);
      $rv=$sth->execute($args{ROLE_ID});
      if ($rv > 0)
      {
        print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Potential credentials query request successful\"/>\n\t<CREDENTIALS>\n";
      }
      my $sets = $sth->fetchall_hashref('obj_res');
      foreach my $nn (sort keys(%$sets))
        {
          print "\t<LINKTYPE  ID=\"S2R\" SET_ID=\"$sets->{$nn}->{'obj_res'}\">\n";
          $query ="select distinct ct.* from _cred_types ct join _objs o on o.otype=ct.otype and ct.subtypes like '%'||o.subtype||'%' where o.obj in
                  (select obj_res from _links where obj_cons=(select obj_res from _links where obj_cons=? and obj_res=?))";
          my $cred = $dbh->selectall_hashref($query, 1, undef, $args{ROLE_ID}, $sets->{$nn}->{'obj_res'});
          foreach my $cr (sort keys(%$cred))
          {
            print "\t\t<CRED ID=\"$cred->{$cr}->{cred}\" SHORT=\"$cred->{$cr}->{name}\" DESCR=\"".uri_escape($cred->{$cr}->{description})."\"/>\n";
          }
          print "\t</LINKTYPE>\n";
        }
      if ($rv > 0)#'0E0'
      {
        print "\t</CREDENTIALS>\n</RESULT>";
      }
      else
      {
        print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Potential credentials does not exists\"/>\n</RESULT>";
      }
    }
  }
  elsif(defined($args{SET_ID}))
  {
 #   my $query = "select obj from _objs where obj=$args{ROLE_ID} and otype='R'";
 #   my $sth=$dbh->prepare($query);
 #   my $rv=$sth->execute;
  #  if ($rv eq '0E0')
  #  {
  #    print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Object ID=$args{ROLE_ID} is not a ROLE type\"/>\n</RESULT>\n";
  #  }
    my $query = "select obj from _objs where obj=? and otype='S'";
    my $sth=$dbh->prepare($query);
    my $rv=$sth->execute($args{SET_ID});
    if($rv eq '0E0')
    {
      print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Object ID=$args{SET_ID} is not a SET type\"/>\n</RESULT>\n";
    }
    else
    {
      print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Potential credentials query request successful\"/>\n\t<CREDENTIALS>\n";
      print "\t<LINKTYPE  ID=\"S2R\" SET_ID=\"$args{SET_ID}\">\n";
      $query ="select distinct ct.*
    	       from _cred_types ct join _objs o on o.otype=ct.otype and ct.subtypes like '%'||o.subtype||'%'
    	       where o.obj in
               (select obj_res from _links where obj_cons=?)
              ";
  #    print "$query\n";
      my $cred = $dbh->selectall_hashref($query, 1, undef, $args{SET_ID});
      foreach my $cr (sort keys(%$cred))
      {
        print "\t\t<CRED ID=\"$cred->{$cr}->{cred}\" SHORT=\"$cred->{$cr}->{name}\" DESCR=\"".uri_escape($cred->{$cr}->{description})."\"/>\n";
      }
      print "\t</LINKTYPE>\n\t</CREDENTIALS>\n</RESULT>\n";

    }
  }
  elsif(defined($args{OBJ_ID}))
  {
    my $query = "select a.name, a.otype, a.subtype  from _obj_otype_subtype a, _objs b
		 where a.otype=b.otype and a.subtype=b.subtype and b.obj=?";
    my $sth=$dbh->selectall_hashref($query, 1, undef, $args{OBJ_ID});#$dbh->prepare($query);
    #my $rv=$sth->execute;
    if (!scalar(%$sth))
    {
      print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Object ID=$args{OBJ_ID} is not exist\"/>\n</RESULT>\n";
    }


    foreach my $n_n (sort keys(%$sth))
    {
      if ($sth->{$n_n}->{'otype'} eq 'D' || $sth->{$n_n}->{'otype'} eq 'X')
      {
          print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Potential credentials query request successful\"/>\n\t<CREDENTIALS>\n";
          print "\t<OBJECT ID=\"$args{OBJ_ID}\" TYPE=\"$sth->{$n_n}->{'otype'}\"  SUBTYPE=\"$sth->{$n_n}->{'name'}\">\n";
          $query = "select a.cred, a.name, a.description
        	    from _cred_types a, _objs b
        	    where a.otype=b.otype and a.subtypes like '%'||b.subtype||'%' and b.obj=?";
          my $cred = $dbh->selectall_hashref($query, 1, undef, $args{OBJ_ID});
          foreach my $cr (sort keys(%$cred))
          {
            print "\t\t<CRED ID=\"$cred->{$cr}->{cred}\" SHORT=\"$cred->{$cr}->{name}\" DESCR=\"".uri_escape($cred->{$cr}->{description})."\"/>\n";
          }
          print "\t</OBJECT>\n\t</CREDENTIALS>\n</RESULT>\n";

      }
      elsif($sth->{$n_n}->{'otype'} eq 'G')
      {
          print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Potential credentials query request successful\"/>\n\t<CREDENTIALS>\n";
          print "\t<OBJECT ID=\"$args{OBJ_ID}\" TYPE=\"$sth->{$n_n}->{'otype'}\"  SUBTYPE=\"$sth->{$n_n}->{'name'}\">\n";
          $query = "select a.cred, a.name, a.description
        	    from _cred_types a, _objs b
        	    where a.otype=b.otype and a.subtypes like '%'||b.subtype||'%' and b.obj=?";
          my $cred = $dbh->selectall_hashref($query, 1, undef, $args{OBJ_ID});
          foreach my $cr (sort keys(%$cred))
          {
            print "\t\t<CRED ID=\"$cred->{$cr}->{cred}\" SHORT=\"$cred->{$cr}->{name}\" DESCR=\"".uri_escape($cred->{$cr}->{description})."\"/>\n";
          }
          print "\t</OBJECT>\n\t</CREDENTIALS>\n</RESULT>\n";

      }
      else
      {
        print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Object ID=$args{OBJ_ID} is not Device or GUI type\"/>\n</RESULT>\n";

      }
    }
  }
  else{return 0;}
return 1;
}

# ---------------------------------------------------------- returnSetInfo -----
sub returnSetInfo {
  my $query;
  my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);
  my @bind_values;

  my $ownerstr = "";
  if ($args{OWNER}){$ownerstr = "and owner = " . $args{OWNER};}

  if (defined($args{ID}))
  {
    @bind_values = ($args{ID});
    $query = "select obj,name,description,protected from _objs where obj=? and otype='S' and deleted =0 $ownerstr";
  }
  elsif(defined($args{ID_LIST}))
  {
    @bind_values = split(',', $args{ID_LIST});
    my $str_phdr = @bind_values ? ('?,' x $#bind_values) . '?' : 'NULL';
    $query = "select obj,name,description,protected from _objs where obj in ($str_phdr) and otype='S' and deleted =0 $ownerstr";
    #$bind_value = $args{ID_LIST};
  }
  else
  {
    $query = "select obj,name,description,protected from _objs where otype='S' and deleted =0 $ownerstr";
  }
  my $sth=$dbh->prepare($query);
  my $rv=$sth->execute(@bind_values);
  if ($rv eq '0E0')
  {
    print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Object ID=$args{OBJ} is not a SET type\"/>\n</RESULT>\n";
  }
  else
  {
    print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"SetInfo query request successful\"/>\n\t<SETS>\n";
    my $sets = $sth->fetchall_hashref('obj');
    foreach my $nn (sort keys(%$sets))
    {
      print "\t\t<SET ID=\"$sets->{$nn}->{'obj'}\"  NAME=\"".uri_escape($sets->{$nn}->{'name'})."\" DESCR=\"".uri_escape($sets->{$nn}->{'description'})."\" PROTECTED=\"$sets->{$nn}->{'protected'}\">\n";

      $query ="
		SELECT _links.obj_cons, concatFields(permission_type.credentials || _links.special_credentials) as credentials, _links.protected
			FROM _objs, permission_type, _links
			WHERE
				_objs.obj = _links.obj_res
				AND obj_res = ?
				AND _objs.deleted = 0
				AND _links.permission = permission_type.permission
			GROUP BY _links.obj_cons, _links.protected;
      ";
      $sth=$dbh->prepare($query);
      $rv=$sth->execute($sets->{$nn}->{'obj'});
      if ($rv ne '0E0')
      {
        my $roles = $sth->fetchall_hashref('obj_cons');
        foreach my $nnn (sort keys(%$roles))
        {
          print "\t\t\t<ROLE_REF ID=\"$roles->{$nnn}->{'obj_cons'}\" CRED=\"$roles->{$nnn}->{'credentials'}\" TYPE=\"R\" PROTECTED=\"$roles->{$nnn}->{'protected'}\"/>\n";
        }
      }

      $query = "
		SELECT _links.obj_res, '' as credentials, _objs.subtype, _objs.otype, _objs.node_id, _links.protected
			FROM _objs, _links
			WHERE
				_objs.obj = _links.obj_res
				AND _links.obj_cons = ?
				AND _objs.deleted = 0;
      ";
      $sth=$dbh->prepare($query);
      $rv=$sth->execute($sets->{$nn}->{'obj'});
      if ($rv ne '0E0')
      {
        my $res = $sth->fetchall_hashref('obj_res');
        # TA3118: Workaround: Hide disabled 'X' objects
        my $objstat = {};
        if(not defined $args{SHOW_DISABLED} or $args{SHOW_DISABLED}!~/^yes$/i) {
	    $objstat = checkEnabled($dbh, $res);
        }
        foreach my $nnnn (sort keys(%$res))
        {
    	  next if defined $objstat->{$nnnn}{enabled} and $objstat->{$nnnn}{enabled} eq 'N';
    	  # Workaround ends
    	  no warnings 'uninitialized';
          print "\t\t\t<RES_REF ID=\"$res->{$nnnn}->{'obj_res'}\" CRED=\"$res->{$nnnn}->{'credentials'}\" TYPE=\"$res->{$nnnn}->{'subtype'}\" PROTECTED=\"$res->{$nnnn}->{'protected'}\"/>\n";
        }
      }

      print "\t\t</SET>\n";
    }
    print "\t</SETS>\n</RESULT>";
  }
}
# ---------------------------------------------------------- returnSetList -----
sub returnSetList {
  my $query;
  my @bind_values;
  my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);

  my $ownerstr = "";
  if ($args{OWNER}){$ownerstr = "and owner = " . $args{OWNER};}
  if (defined $args{ID})
  {
    @bind_values = ($args{ID});
    $query = "select obj,name,description,protected from _objs where obj=? and otype='S' and deleted =0 $ownerstr";
  }
  elsif(defined $args{ID_LIST})
  {
    @bind_values = split(',', $args{ID_LIST});
    my $str_phdr = @bind_values ? ('?,' x $#bind_values) . '?' : 'NULL';
    $query = "select obj,name,description,protected from _objs where obj in ($str_phdr) and otype='S' and deleted =0 $ownerstr";
  }
  else
  {
    $query = "select obj,name,description,protected from _objs where otype='S' and deleted =0 $ownerstr";
  }
  my $sth=$dbh->prepare($query);
  my $rv=$sth->execute(@bind_values);
  if ($rv eq '0E0')
  {
    print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Object ID=$args{OBJ} is not a SET type\"/>\n</RESULT>\n";
  }
  else
  {
    print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"SetList query request successful\"/>\n\t<SETS>\n";

    my $sets = $sth->fetchall_hashref('obj');
    foreach my $nn (sort keys(%$sets))
    {
      print "\t\t<SET ID=\"$sets->{$nn}->{'obj'}\"  NAME=\"".uri_escape($sets->{$nn}->{'name'})."\" DESCR=\"".uri_escape($sets->{$nn}->{'description'})."\" PROTECTED=\"$sets->{$nn}->{'protected'}\"/>\n";
    }
    print "\t</SETS>\n</RESULT>";
  }
}
# ---------------------------------------------------------- returnResourceList -----
sub returnResourceList {

#-	otype={D | G}	optional object type
#-	subtype=xx		optional object subtype (depends on otype)
#-	subtype_list=xx{,xx}	optional object subtypes  list (depends on otype)
#-	id=xx			optional resource ID
#-	id_list=xx{,xx}	optional resource ID list

  my $query;
  my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);
  my @bind_values;

  my $ownerstr = "";
  if ($args{OWNER}){$ownerstr = "and owner = " . $args{OWNER};}

  my ($str_idlist, $str_stlist) = ('', '');
  if($args{ID}) {
    push @bind_values, $args{ID};
  }
  if($args{ID_LIST}) {
    my @id_list = split(',', $args{ID_LIST});
    push @bind_values, @id_list;
    $str_idlist = @id_list ? ('?,' x $#id_list) . '?' : 'NULL';
  }
  if($args{OTYPE}) {
    push @bind_values, $args{OTYPE};
  }
  if($args{SUBTYPE}) {
    push @bind_values, $args{SUBTYPE};
  }
  if($args{SUBTYPE_LIST}) {
    my @st_list = split(',', $args{SUBTYPE_LIST});
    push @bind_values, @st_list;
    $str_stlist = @st_list ? ('?,' x $#st_list) . '?' : 'NULL';
  }
  my $conditions="deleted =0 and subtype!='N'".(($args{ID})?"and obj=?":'').
		  (($args{ID_LIST})?"and obj in $str_idlist":'').
                  (($args{OTYPE})?" and otype=?":" and otype in ('D','G')").
                  (($args{SUBTYPE})?" and subtype=?":'').
                  (($args{SUBTYPE_LIST})?" and subtype in ($str_stlist)":'');
  $query = "select obj,name,description,otype,subtype,node_id,location from _objs where ".$conditions;

  my $sth=$dbh->prepare($query);
  my $rv=$sth->execute(@bind_values);
  if ($rv eq '0E0')
  {
    print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"NO RESOURCE available\"/>\n</RESULT>\n";
  }
  else
  {
    print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"ResourceList query request successful\"/>\n";
    my $dev_s;
    my $gui_s;
    my $sets = $sth->fetchall_hashref('obj');
    foreach my $nn (sort keys(%$sets))
    {
      if($sets->{$nn}->{'otype'} eq 'D')
      {
        $dev_s.= "\t\t<DEVICE  ID=\"$sets->{$nn}->{'obj'}\"  NAME=\"".uri_escape($sets->{$nn}->{'name'})."\" OTYPE=\"$sets->{$nn}->{'otype'}\" SUBTYPE=\"$sets->{$nn}->{'subtype'}\"  DESCR=\"".uri_escape($sets->{$nn}->{'description'})."\" LOC=\"$sets->{$nn}->{'location'}\" NODEID=\"$sets->{$nn}->{'node_id'}\"/>\n";
      }
      elsif($sets->{$nn}->{'otype'} eq 'G')
      {
        $gui_s.= "\t\t<GUI ID=\"$sets->{$nn}->{'obj'}\"  NAME=\"".uri_escape($sets->{$nn}->{'name'})."\" OTYPE=\"$sets->{$nn}->{'otype'}\" SUBTYPE=\"$sets->{$nn}->{'subtype'}\" DESCR=\"".uri_escape($sets->{$nn}->{'description'})."\" LOC=\"$sets->{$nn}->{'location'}\" />\n";
      }
    }
    my $res_f =((defined($dev_s))?"\t<DEVICES>\n$dev_s\t</DEVICES>\n":'').((defined($gui_s))?"\t<GUIS>\n$gui_s\t</GUIS>\n":'')."</RESULT>";
    print $res_f;#((defined($dev_s))?"\t<DEVICES>\n$dev_s\t</DEVICES>\n":'').((defined($gui_s))?"\t<GUIS>\n$gui_s\t</GUIS>\n":'')."</RESULT>";

  }
}

# ---------------------------------------------------------- returnResourceInfo -----
sub returnResourceInfo {
    #-	otype={D | G}	optional object type
    #-	subtype=xx		optional object subtype (depends on otype)
    #-	subtype_list=xx{,xx}	optional object subtypes  list (depends on otype)
    #-	id=xx			optional resource ID
    #-	id_list=xx{,xx}	optional resource ID list

  my $query;
  my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);
  my @bind_values;

  my $ownerstr = "";
  if ($args{OWNER}){$ownerstr = "and owner = " . $args{OWNER};}

  my ($str_idlist, $str_stlist) = ('', '');
  if($args{ID}) {
    push @bind_values, $args{ID};
  }
  if($args{ID_LIST}) {
    my @id_list = split(',', $args{ID_LIST});
    push @bind_values, @id_list;
    $str_idlist = @id_list ? ('?,' x $#id_list) . '?' : 'NULL';
  }
  if($args{OTYPE}) {
    push @bind_values, $args{OTYPE};
  }
  if($args{SUBTYPE}) {
    push @bind_values, $args{SUBTYPE};
  }
  if($args{SUBTYPE_LIST}) {
    my @st_list = split(',', $args{SUBTYPE_LIST});
    push @bind_values, @st_list;
    $str_stlist = @st_list ? ('?,' x $#st_list) . '?' : 'NULL';
  }
  my $conditions="deleted =0 and subtype!='N'".(($args{ID})?"and obj=?":'').
		  (($args{ID_LIST})?"and obj in ($str_idlist)":'').
                  (($args{OTYPE})?" and otype=?":" and otype in ('X','D','G')").
                  (($args{SUBTYPE})?" and subtype=?":'').
                  (($args{SUBTYPE_LIST})?" and subtype in ($str_stlist)":'');

    my @dev_type; # - loading device subtypes not the NODEs or GLOBALs
    $query = "select otype,subtype from _obj_otype_subtype where (otype='D' and subtype not in('N','G')) or (otype='X' and subtype != 'G') order by otype, subtype";
    my $sth=$dbh->prepare($query);
    my $rv=$sth->execute;
    my $sets = $sth->fetchall_arrayref();
    my $ind=0;
    while( $ind< $rv)
    {
        $dev_type[$ind]{OT}=$sets->[$ind][0];
        $dev_type[$ind]{ST}=$sets->[$ind][1];
        $ind++;
    }

    # - query for exact data
    $query = "select obj,name,description,otype,subtype,node_id,location from _objs where ".$conditions.' order by otype, subtype, description';
    my %dev_str;
    my $gui_s;
    $rv='';
    $sth=$dbh->prepare($query);
    $rv=$sth->execute(@bind_values);
    if ($rv eq '0E0')
    {
        print "<RESULT>\n<STATUS VALUE=\"ERROR\" MESSAGE=\"NO RESOURCE available\"/>\n</RESULT>\n";
    }
    else
	{
		print "<RESULT>\n<STATUS VALUE=\"OK\" MESSAGE=\"ResourceList query request successful\"/>\n";
		my $sets = $sth->fetchall_hashref('obj');

		# TA3118: Workaround for hiding 'X' objects with ENABLED='N'
		my $objstat = {};	# 'X' objects statistics
		if(not defined $args{SHOW_DISABLED} or $args{SHOW_DISABLED}!~/^yes$/i) {
			$objstat = checkEnabled($dbh, $sets);
		}

		foreach my $type (@dev_type)
		{
			foreach my $nn (sort {$sets->{$a}->{description} cmp $sets->{$b}->{description}} keys %$sets)
			{
				if (
					($sets->{$nn}->{'otype'} eq $type->{OT})
					and
					($sets->{$nn}->{'subtype'} eq $type->{ST})
				)
				{
					# TA3118: Workaround for hiding 'X' objects with ENABLED='N'
					next if defined $objstat->{$nn}{enabled} and $objstat->{$nn}{enabled} eq 'N';
					# Workaround ends

					no warnings 'uninitialized';

					$dev_str{$type}.= "<DEVICE  ID=\"$sets->{$nn}->{'obj'}\"  NAME=\"".uri_escape($sets->{$nn}->{'name'})."\" OTYPE=\"$sets->{$nn}->{'otype'}\" SUBTYPE=\"$sets->{$nn}->{'subtype'}\"  DESCR=\"".uri_escape($sets->{$nn}->{'description'})."\" LOC=\"".uri_escape($sets->{$nn}->{'location'})."\" NODEID=\"$sets->{$nn}->{'node_id'}\">\n";
					my $query_set="
						SELECT _links.obj_cons, _links.protected, '' as credentials
							FROM _objs, _links
							WHERE
								_objs.obj = _links.obj_res
								AND obj_res = ?
								AND _objs.deleted = 0
								AND _links.link_type = 'D2S';";
					my $sth_s=$dbh->prepare($query_set);
					my $res=$sth_s->execute($sets->{$nn}->{'obj'});
					if ($res > 0)
					{
						my $sets_s = $sth_s->fetchall_hashref('obj_cons');
						foreach my $nn_s (sort keys(%$sets_s))
						{
							$dev_str{$type}.="<SET_REF ID=\"$sets_s->{$nn_s}->{'obj_cons'}\"  PROTECTED=\"$sets_s->{$nn_s}->{'protected'}\" CRED=\"$sets_s->{$nn_s}->{'credentials'}\"/>\n";
						}
					}
					$dev_str{$type}.= "</DEVICE>\n";
				}
			}
		}
		foreach my $nn (keys(%$sets))
		{
			if($sets->{$nn}->{'otype'} eq 'G')
			{
				$gui_s.= "\t\t<GUI ID=\"$sets->{$nn}->{'obj'}\" NAME=\"".uri_escape($sets->{$nn}->{'name'})."\" OTYPE=\"$sets->{$nn}->{'otype'}\" SUBTYPE=\"$sets->{$nn}->{'subtype'}\"  DESCR=\"".uri_escape($sets->{$nn}->{'description'})."\" >\n";
				my $query_set="
					SELECT _links.obj_cons, _links.protected, '' as credentials
						FROM _objs, _links
						WHERE
							_objs.obj = _links.obj_res
							AND obj_res = ?
							AND _objs.deleted = 0
							AND _links.link_type = 'G2S';";
				my $sth_s=$dbh->prepare($query_set);
				my $res=$sth_s->execute($sets->{$nn}->{'obj'});
				if ($res > 0)
				{
					my $sets_s = $sth_s->fetchall_hashref('obj_cons');
					foreach my $nn_s (sort keys(%$sets_s))
					{
						$gui_s.="\t\t\t<SET_REF ID=\"$sets_s->{$nn_s}->{'obj_cons'}\"  PROTECTED=\"$sets_s->{$nn_s}->{'protected'}\" CRED=\"$sets_s->{$nn_s}->{'credentials'}\"/>\n";
					}
				}
				$gui_s.= "\t\t</GUI>\n";
			}
		}

		my $res_f;
		foreach (sort keys(%dev_str))
		{
			$res_f.=$dev_str{$_};
		}
		$res_f = (defined($res_f))?"<DEVICES>\n$res_f</DEVICES>\n":'';
		$res_f.=((defined($gui_s))?"<GUIS>\n$gui_s</GUIS>\n":'')."</RESULT>";
		print $res_f;
	}
}

# ---------------------------------------------------------- returnOTypes ----- otypes lookup
sub returnOTypes {
  my $query= "select * from _obj_otype_subtype order by otype";
  my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);

  my $emps = $dbh->selectall_arrayref($query, { Slice => {} } );

  if (!scalar(@$emps))
  {
    print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"OTypes query request fault\"/>\n</RESULT>\n";
  }
  else
  {
    print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"OTypes query request successful\"/>\n\t<OTYPES>\n";

    foreach my $emp ( @$emps )
    {
      print "\t\t<OTYPE  ID=\"$emp->{'otype'}\"  SUBTYPE=\"$emp->{'subtype'}\" DESCR=\"".uri_escape($emp->{'name'})."\"/>\n";
    }
    print "\t</OTYPES>\n</RESULT>";
  }
}

# ---------------------------------------------------------- returnLinkTypes ----- linktypes lookup
sub returnLinkTypes {
  my $query= "select * from _link_types";
  my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);

  my $emps = $dbh->selectall_arrayref($query, { Slice => {} } );

  if (!scalar(@$emps))
  {
    print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Link Types query request fault\"/>\n</RESULT>\n";
  }
  else
  {
    print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Link Types query request successful\"/>\n\t<LINKTYPES>\n";

    foreach my $emp ( @$emps )
    {
      print "\t\t<LINKTYPE  ID=\"$emp->{'link_type'}\"  DESCR=\"".uri_escape($emp->{'name'})."\" ALLOW_CREDS=\"".(($emp->{'allow_creds'})?'yes':'no')."\" USE_SUBTYPE=\"".(($emp->{'use_types'})?'yes':'no')."\"/>\n";
    }
    print "\t</LINKTYPES>\n</RESULT>";
  }
}

# ---------------------------------------------------------- returnCredTypes ----- CredTypes lookup
sub returnCredTypes {
  my $query= "select * from _link_types";
  my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);

  my $emps = $dbh->selectall_arrayref($query, { Slice => {} } );

  if (!scalar(@$emps))
  {
    print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Link Types query request fault\"/>\n</RESULT>\n";
  }
  else
  {
    print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Link Types query request successful\"/>\n\t<LINKTYPES>\n";

    foreach my $emp ( @$emps )
    {
      print "\t\t<LINKTYPE  ID=\"$emp->{'link_type'}\"  DESCR=\"".uri_escape($emp->{'name'})."\" ALLOW_CREDS=\"$emp->{'allow_creds'}\" USE_SUBTYPE=\"".(($emp->{'use_types'})?'yes':'no')."\"/>\n";
    }
    print "\t</LINKTYPES>\n</RESULT>";
  }
}
# ---------------------------------------------------------- returnRoleInfo -----
sub returnRoleInfo {
  my $query;
  my @bind_values;
  my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);

  my $ownerstr = "";
  if ($args{OWNER}){$ownerstr = "and owner = " . $args{OWNER};}

  if ($args{ID})
  {
    @bind_values = ($args{ID});
    $query = "select obj,name,description,protected from _objs where obj=? and otype='R' $ownerstr;";
  }
  elsif($args{ID_LIST})
  {
    @bind_values = split(',', $args{ID_LIST});
    my $str_phdr = @bind_values ? ('?,' x $#bind_values) . '?' : 'NULL';
    $query = "select obj,name,description,protected from _objs where obj in ($str_phdr) and otype='R' $ownerstr";
  }
  else
  {
    $query = "select obj,name,description,protected from _objs where otype='R' $ownerstr";
  }
  my $sth=$dbh->prepare($query);
  my $rv=$sth->execute(@bind_values);
  if ($rv eq '0E0')
  {
    print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Object ID=$args{OBJ} is not a ROLE type\"/>\n</RESULT>\n";
  }
  else
  {
    print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"RoleInfo query request successful\"/>\n\t<ROLES>\n";
    my $sets = $sth->fetchall_hashref('obj');
    foreach my $nn (sort keys(%$sets))
    {
      print "\t\t<ROLE ID=\"$sets->{$nn}->{'obj'}\"  NAME=\"".uri_escape($sets->{$nn}->{'name'})."\" DESCR=\"".uri_escape($sets->{$nn}->{'description'})."\" PROTECTED=\"$sets->{$nn}->{'protected'}\">\n";

      $query =
      "SELECT _links.obj_res, concatFields(permission_type.credentials || _links.special_credentials) as credentials, _links.protected
           FROM _objs, permission_type, _links
           WHERE
               _objs.obj = _links.obj_res
               AND _links.link_type = 'S2R'
               AND _links.obj_cons = ?
               AND _links.permission = permission_type.permission
           GROUP BY _links.obj_res, _links.protected;";
      $sth=$dbh->prepare($query);
      $rv=$sth->execute($sets->{$nn}->{'obj'});
      if ($rv ne '0E0')
      {
        my $roles = $sth->fetchall_hashref('obj_res');
        foreach my $nnn (sort keys(%$roles))
        {
          print "\t\t\t<SET_REF ID=\"$roles->{$nnn}->{'obj_res'}\" CRED=\"$roles->{$nnn}->{'credentials'}\" PROTECTED=\"$roles->{$nnn}->{'protected'}\"/>\n";
        }
      }
      $query ="select a.obj_res, a.protected from _links a join _objs b on b.obj = a.obj_res and link_type = 'U2R' and obj_cons = ?;";
      $sth=$dbh->prepare($query);
      $rv=$sth->execute($sets->{$nn}->{'obj'});
      if ($rv ne '0E0')
      {
        my $res = $sth->fetchall_hashref('obj_res');
        foreach my $nnnn (sort keys(%$res))
        {
          print "\t\t\t<USER_REF ID=\"$res->{$nnnn}->{'obj_res'}\" PROTECTED=\"$res->{$nnnn}->{'protected'}\"/>\n";
        }
      }

      print "\t\t</ROLE>\n";
    }
    print "\t</ROLES>\n</RESULT>";
  }}
# ---------------------------------------------------------- returnRoleList -----
sub returnRoleList {
  my $query;
  my @bind_values;
  my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);

  my $ownerstr = "";
  if ($args{OWNER}){$ownerstr = "and owner = " . $args{OWNER};}

  if ($args{ID})
  {
    @bind_values = ($args{ID});
    $query = "select obj,name,description,protected from _objs where obj=? and otype='R' $ownerstr;";
  }
  elsif($args{ID_LIST})
  {
    @bind_values = split(',', $args{ID_LIST});
    my $str_phdr = @bind_values ? ('?,' x $#bind_values) . '?' : 'NULL';
    $query = "select obj,name,description,protected from _objs where obj in ($str_phdr) and otype='R' $ownerstr";
  }
  else
  {
    $query = "select obj,name,description,protected from _objs where otype='R' $ownerstr";
  }
  my $sth=$dbh->prepare($query);
  my $rv=$sth->execute(@bind_values);
  if ($rv eq '0E0')
  {
    my $obj = $args{OBJ} ? $args{OBJ} : "";
    print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Object ID=$obj is not a ROLE type\"/>\n</RESULT>\n";
  }
  else
  {
    print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"RoleList query request successful\"/>\n\t<ROLES>\n";
    my $roles = $sth->fetchall_hashref('obj');
    foreach my $nn (sort keys(%$roles))
    {
      print "\t\t<ROLE ID=\"$roles->{$nn}->{'obj'}\"  NAME=\"".uri_escape($roles->{$nn}->{'name'})."\" DESCR=\"".uri_escape($roles->{$nn}->{'description'})."\" PROTECTED=\"$roles->{$nn}->{'protected'}\"/>\n";
    }
    print "\t</ROLES>\n</RESULT>";
  }
}



# ---------------------------------------------------------- returnUserInfo -----
sub returnUserInfo {
  my $query;
  my @bind_values;
  my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);

  my $ownerstr = "";
  if ($args{OWNER}){$ownerstr = "and o.owner = " . $args{OWNER};}

  if ($args{ID})
  {
    @bind_values = ($args{ID});
    $query = "select o.obj,name,description,protected,'0' as role_combine,'' as email,'' as email_int, a.val as language from _objs o LEFT JOIN (select * from _obj_attr where attr = 'LANGUAGE') a on o.obj = a.obj where o.deleted = 0 and o.obj=? and o.otype='U' $ownerstr;";
  }
  elsif($args{ID_LIST})
  {
    @bind_values = split(',', $args{ID_LIST});
    my $str_phdr = @bind_values ? ('?,' x $#bind_values) . '?' : 'NULL';
    $query = "select o.obj,o.name,o.description,o.protected,'0' as role_combine,'' as email,'' as email_int, a.val as language from _objs o LEFT JOIN (select * from _obj_attr where attr = 'LANGUAGE') a on o.obj = a.obj where o.deleted = 0 and o.obj in ($str_phdr) and o.otype='U' $ownerstr";
  }
  else
  {
	$query = "select o.obj,o.name,o.description,o.protected,'0' as role_combine,'' as email,'' as email_int, a.val as language from _objs o LEFT JOIN (select * from _obj_attr where attr = 'LANGUAGE') a on o.obj = a.obj where o.deleted = 0 and o.otype='U' $ownerstr";
  }
  my $sth=$dbh->prepare($query);
  my $rv=$sth->execute(@bind_values);
  if ($rv eq '0E0')
  {
    print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Object ID=$args{OBJ} is not a User type\"/>\n</RESULT>\n";
  }
  else
  {
    print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"UserInfo query request successful\"/>\n\t<USERS>\n";
    my $sets = $sth->fetchall_hashref('obj');
    foreach my $nn (sort keys(%$sets))
    {
      print "\t\t<USER ID=\"$sets->{$nn}->{'obj'}\" NAME=\"".uri_escape($sets->{$nn}->{'name'})."\" DESCR=\"".uri_escape($sets->{$nn}->{'description'})."\" PROTECTED=\"$sets->{$nn}->{'protected'}\" ROLE_COMBINE=\"$sets->{$nn}->{'role_combine'}\" EMAIL=\"".((defined($sets->{$nn}->{'email'}))?"$sets->{$nn}->{'email'}":'')."\" EMAIL_INT=\"".((defined($sets->{$nn}->{'email_int'}))?"$sets->{$nn}->{'email_int'}":'')."\" LANGUAGE=\"".((defined($sets->{$nn}->{'language'}))?"$sets->{$nn}->{'language'}":'EN')."\">\n";

	# get default role here
	  my $def_role_id = 0;
      $query =" select * from _obj_attr where obj=? and attr='DEFAULT_ROLE_ID'";
      $sth=$dbh->prepare($query);
      $rv=$sth->execute($sets->{$nn}->{'obj'});
      if ($rv ne '0E0')
      {
        my $res = $sth->fetchall_hashref('val');
        foreach my $nnnn (sort keys(%$res))
        {
          $def_role_id = $res->{$nnnn}->{'val'};
        }
      }
	# eof get default role here

      $query ="select a.obj_cons, a.protected from _links a where a.obj_res=?";
      $sth=$dbh->prepare($query);
      $rv=$sth->execute($sets->{$nn}->{'obj'});
      if ($rv ne '0E0')
      {
        my $res = $sth->fetchall_hashref('obj_cons');
        foreach my $nnnn (sort keys(%$res))
        {
		# add default role here
		  if ($def_role_id == $res->{$nnnn}->{'obj_cons'})
			{
				print "\t\t\t<ROLE_REF ID=\"$res->{$nnnn}->{'obj_cons'}\" PROTECTED=\"$res->{$nnnn}->{'protected'}\" DEFAULT_ROLE=\"true\"/>\n";
			}
		  else
			{
				print "\t\t\t<ROLE_REF ID=\"$res->{$nnnn}->{'obj_cons'}\" PROTECTED=\"$res->{$nnnn}->{'protected'}\"/>\n";
			}
        }
      }

      print "\t\t</USER>\n";
    }
    print "\t</USERS>\n</RESULT>";
  }
}
# ---------------------------------------------------------- returnUserList -----
sub returnUserList {
  my $query;
  my @bind_values;
  my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);

  my $ownerstr = "";
  if ($args{OWNER}){$ownerstr = "and owner = " . $args{OWNER};}

  if ($args{ID})
  {
    @bind_values = ($args{ID});
    $query = "select obj,name,description,protected,role_combine,email from _objs where deleted = 0 and obj=? and otype='U' $ownerstr;";
  }
  elsif($args{ID_LIST})
  {
    @bind_values = split(',', $args{ID_LIST});
    my $str_phdr = @bind_values ? ('?,' x $#bind_values) . '?' : 'NULL';
    $query = "select obj,name,description,protected,role_combine,email from _objs where deleted = 0 and obj in ($str_phdr) and otype='U' $ownerstr";
  }
  else
  {
    $query = "select obj,name,description,protected,role_combine,email from _objs where deleted = 0 and otype='U' $ownerstr";
  }
  my $sth=$dbh->prepare($query);
  my $rv=$sth->execute(@bind_values);
  if ($rv eq '0E0')
  {
    print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Object ID=$args{OBJ} is not a User type\"/>\n</RESULT>\n";
  }
  else
  {
    print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"UserList query request successful\"/>\n\t<USERS>\n";
    my $sets = $sth->fetchall_hashref('obj');
    foreach my $nn (sort keys(%$sets))
    {
      print "\t\t<USER ID=\"$sets->{$nn}->{'obj'}\" NAME=\"".uri_escape($sets->{$nn}->{'name'})."\" DESCR=\"".uri_escape($sets->{$nn}->{'description'})."\" PROTECTED=\"$sets->{$nn}->{'protected'}\" ROLE_COMBINE=\"$sets->{$nn}->{'role_combine'}\" EMAIL=\"".((defined($sets->{$nn}->{'email'}))?"$sets->{$nn}->{'email'}":'')."\"/>\n";
    }
    print "\t</USERS>\n</RESULT>";
  }
}

#===========================================refreshresources===========================================================
sub refreshresources {

    my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);
    my $count=0;
    my $rows = 0;
    my $xmlstr=get("http://$ENV{SERVER_ADDR}/api/cgi-bin/hostinfo.cgi?return=domain".((defined $SID and $SID!=1)?"&sid=$SID":''));
    my $nod = XMLin($xmlstr, ForceArray => 1);
    my $query = "";
    my %hosts;

	#print "<!--".Dumper($nod)."-->\n";

    if($args{NODEID})
    {
		print STDERR "crdmng.cgi?modify=refreshresources&NODEID=xx is not supported anymore!!!";
		print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"crdmng.cgi?modify=refreshresources&amp;NODEID=xx is not supported anymore!!!\"/>\n</RESULT>\n";
		exit 1;
    }
    elsif($args{NODENAME})
    {
        if ($args{NODENAME}=~/MYIP/i)
        {
			print STDERR "crdmng.cgi?modify=refreshresources&NODENAME=MYIP is not supported anymore!!!";
			print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"crdmng.cgi?modify=refreshresources&amp;NODENAME=MYIP is not supported anymore!!!\"/>\n</RESULT>\n";
			exit 1;
        }
        else
        {
            if($args{DEVID})
			{
				if(refreshOne())
				{
					print "<RESULT>\n<STATUS VALUE=\"OK\" MESSAGE=\"$message\"/>\n</RESULT>\n";
					return 1;
				}
			}
			else
			{
				#=============================================================== UPDATE NODE config INFO>
				for my $a (@{$nod->{DOMAIN}[0]->{NODE}})
				{
					next if ($a->{'UNI'} ne $args{NODENAME});
					$hosts{$a->{'UNI'}}=
						{
							'UNI'       => $a->{'UNI'},
							'HOST'      => $a->{'HOST'},
							'IP'        => $a->{'IP'},
							'VERID'     => $a->{'VERID'},
							'RTSP_PORT' => $a->{'RTSP_PORT'}
						};
				}
				$query = "select obj,name,node_ip,node_id from _objs where otype='D' and subtype='N'";
				my $nod_from_db = $dbh->selectall_hashref($query, 1);
				foreach my $nn (keys(%$nod_from_db))
				{
					if(defined($hosts{$nod_from_db->{$nn}{'name'}}))
					{
						$hosts{$nod_from_db->{$nn}{'name'}}{'obj'}=$nn;
						foreach my $nn_atr (keys(%{$hosts{$nod_from_db->{$nn}{'name'}}}))
						{
							$query = "update  _obj_attr set val=\'".uri_unescape($hosts{$nod_from_db->{$nn}{'name'}}{$nn_atr})."\' where obj=\'$nn\' and attr='$nn_atr'";
							my $rows_na=$dbh->do($query);
							if ($rows_na < 1)
							{
								$query = "insert into _obj_attr (obj,attr,val) values (\'$nn\',\'$nn_atr\',\'".uri_unescape($hosts{$nod_from_db->{$nn}{'name'}}{$nn_atr})."\')";
								$rows_na=$dbh->do($query);
							}
						}
					}
				}
				#<======================================================================
			}
        }
    }
    else # no NODEID / no NODENAME
    {
        for my $a (@{$nod->{DOMAIN}[0]->{NODE}})
        {
			$hosts{$a->{'UNI'}}=
				{
					'UNI'       => $a->{'UNI'},
					'HOST'      => $a->{'HOST'},
					'IP'        => $a->{'IP'},
					'VERID'     => $a->{'VERID'},
					'RTSP_PORT' => $a->{'RTSP_PORT'}
				};
        }
        #=======================================================deleting devices from removed NODES and insert obj into existing NODES=================================================
        $query = "SELECT obj,name,node_ip,node_id FROM _objs WHERE otype='D' and subtype='N'";
        my $nod_from_db = $dbh->selectall_hashref($query, 1);
        foreach my $nn (keys(%$nod_from_db))
        {
            if(!defined($hosts{$nod_from_db->{$nn}{'name'}}))
            {
                $query = "update  _objs set deleted='1' where node_id=\'$nn\'";
                my $rows_n=$dbh->do($query);
            }
            else
            {
                $hosts{$nod_from_db->{$nn}{'name'}}{'obj'}=$nn;
                foreach my $nn_atr (keys(%{$hosts{$nod_from_db->{$nn}{'name'}}}))
                {
                    $query = "update  _obj_attr set val=\'".((defined($hosts{$nod_from_db->{$nn}{'name'}}{$nn_atr}))?uri_unescape($hosts{$nod_from_db->{$nn}{'name'}}{$nn_atr}):'')."\' where obj=\'$nn\' and attr='$nn_atr'";
                    my $rows_na=$dbh->do($query);
                    if ($rows_na < 1)
                    {
                        $query = "insert into _obj_attr (obj,attr,val) values (\'$nn\',\'$nn_atr\',\'".uri_unescape($hosts{$nod_from_db->{$nn}{'name'}}{$nn_atr})."\')";
                        $rows_na=$dbh->do($query);
                    }
                }
            }
        }
		#=======================================================edit of deleting devices from removed NODES =========================================
		#=======================================================try insert new NODES =========================================
        foreach my $nn (keys(%hosts))
        {
            if(!defined($hosts{$nn}{'obj'}))
            {
                $query = "insert into _objs (otype,subtype,name,location )
                values ('D','N','$nn',\'$hosts{$nn}{'HOST'}\')";
                my $rows=$dbh->do($query);
                if ($rows>0)
                {
                    $query = "select currval('seq_obj')";
                    my @row_dyna_types = $dbh->selectrow_array($query);
                    $hosts{$nn}{'obj'}=$row_dyna_types[0];

                    foreach my $nn_atr (keys(%{$hosts{$nn}}))
                    {
                        $query = "insert into _obj_attr (obj,attr,val) values (\'$hosts{$nn}{'obj'}\',\'$nn_atr\',\'".uri_unescape($hosts{$nn}{$nn_atr})."\')";
                        $rows=$dbh->do($query);
                    }
                }
            }
        }
    }

	#print "<!--".Dumper(\%hosts)."-->\n";

	#=======================================================Create TMP tables========================================================================

	$query="CREATE TEMPORARY TABLE DEV_TMP  as select * from v_devs where name=\'\'";#TEMPORARY TABLE for new devices
	$rows=$dbh->do($query);
	$query="ALTER  TABLE DEV_TMP  ADD COLUMN deleted integer";#CHANGE STRUCT TEMPORARY TABLE for new devices
	$rows=$dbh->do($query);

	$query="CREATE TEMPORARY TABLE OBJ_ATTR_TMP (node_id int,name varchar(30),attr varchar,val varchar)";  #TEMPORARY TABLE for new dev attr
	$rows=$dbh->do($query);
	my $sth = $dbh->prepare( q{
	  insert into OBJ_ATTR_TMP ( node_id ,name  , attr, val) VALUES (?,? ,?,?)
	   });
	if (!$message)
	{
		for my $a (keys(%hosts))#(@{$nod->{DOMAIN}[0]->{NODE}})
		{
		    my $UR="http://$hosts{$a}{'IP'}/api/cgi-bin/devinfo.cgi?return=conf".((defined $SID and $SID!=1)?"&sid=$SID":'');
		    my $xmlstr_n=get("$UR");
		    next if (! defined($xmlstr_n));

			my $dev_nod = XMLin($xmlstr_n, ForceArray => 1);
			my %dev_for_upd;
			#print "<!--".Dumper($dev_nod)."-->\n";
		    #=======================================================edit of _objs========================================================================
		    for my $dev_list (@{$dev_nod->{DEVICE}}) # run insert or update to _objs and _obj_attr per device
		    {
				my $name=$dev_list->{ID};
				my $description=$dev_list->{NAME}[0]->{VALUE};
				if (!defined ($description))
				{
					$log->warn("Dev $name from server $hosts{$a}{'UNI'} get empty conf FILE");
					$err_message.="Dev $name from server $hosts{$a}{'UNI'} get empty conf FILE";
					next;
				}
			    $dev_list->{DEVICETYPE}[0]=~/(.)/;
				#print "<!-- ".Dumper($hosts{$a})." -->\n";
			    my $subtype=$1;
			    my $node_id=$hosts{$a}{obj};
			    my $node_ip=$hosts{$a}{UNI};
			    my $location=$dev_list->{LOCATION}[0]->{VALUE};
			    my $obj_atr=(($dev_list->{POSITIONCTL}[0]->{VALUE})?$dev_list->{POSITIONCTL}[0]->{VALUE}:'none');
			    $dev_for_upd{$name}=$node_id;

			    if ($subtype!~/N/i)
			    {
			        $query= "insert into DEV_TMP ( subtype, name, description,node_id, node_ip,location,obj_atr,deleted) ".
						"VALUES (\'$subtype\', \'$name\', \'$description\',\'$node_id\', \'$node_ip\', \'$location\', \'$obj_atr\',\'0\')";
			        #print "<!-- $query -->\n";
					$rows=$dbh->do($query);
			        $count++;
			        #=======================================================end edit of _objs========================================================================
					#====================================================== edit of _obj_attr ========================================================================
			        my $ind=scalar((keys %{$dev_list}));
			        my %tmp_dev=%{$dev_list};
			        for my $attr (keys %tmp_dev)
					{
			            my $val ='';
			            my $rows_s=0;
			            if ($tmp_dev{$attr}=~/ARRAY/)
			            {
							if ($tmp_dev{$attr}[0]=~/HASH/)
							{
								$val =uri_unescape($tmp_dev{$attr}[0]->{VALUE});
							}
							else
							{
								$val =uri_unescape($tmp_dev{$attr}[0]);
							}
			            }
			            else
			            {
							$val =uri_unescape($tmp_dev{$attr});
			            }
			                $rows_s=$sth->execute($node_id, $dev_list->{ID} , $attr, $val); # insert all existing obj attr into temp table
			        } #====================================================== end edit of _obj_attr ========================================================================
				}
			}
			#====================================================== mark deleted devices ========================================================================
		    $query = "select name from _objs where node_id=\'$hosts{$a}{'obj'}\'";#.(($args{DEVID})?" and name=\'$args{DEVID}\'":'');# - coment out because  it is allow to update ALL devid=3 from ALL nodes
		    my $dev_from_db = $dbh->selectall_hashref($query, 1);
		    foreach my $dd (keys(%$dev_from_db))
		    {
				if(!defined($dev_for_upd{$dd}))
				{
					$query = "update  _objs set deleted='1' where node_id=\'$hosts{$a}{'obj'}\' and name=\'$dd\'";
					my $rows_c=$dbh->do($query);
				}
		    }
			#====================================================== end mark deleted devices ========================================================================
		}
		$query = "update  _objs set deleted=foo.deleted, node_ip=foo.node_ip ,node_alt_ip=foo.node_alt_ip, obj_atr=foo.obj_atr, location=foo.location, description=foo.description from
              (select  node_id,name,deleted,node_ip ,node_alt_ip,obj_atr,location,description from dev_tmp where exists  (select * from _objs where otype='D' and _objs.node_id=dev_tmp.node_id and _objs.name=dev_tmp.name )) as foo where _objs.node_id=foo.node_id and _objs.name=foo.name;";
		my $res_u=$dbh->do($query);

	    $query = "insert into _objs (otype,subtype,name,node_id , node_ip ,node_alt_ip,obj_atr,location,description )
	              (select 'D'as otype,subtype,name,node_id , node_ip ,node_alt_ip,obj_atr,location,description from dev_tmp where not exists  (select * from _objs where otype='D' and _objs.node_id=dev_tmp.node_id and _objs.name=dev_tmp.name))";
	    my $res_i=$dbh->do($query);

	    $query = "update _obj_attr set val=OBJ_ATTR_TMP.val from OBJ_ATTR_TMP where _obj_attr.obj=(select obj from _objs where name=OBJ_ATTR_TMP.name and node_id=OBJ_ATTR_TMP.node_id) and _obj_attr.attr=OBJ_ATTR_TMP.attr";
	    $res_u=$dbh->do($query);

	    $query = "insert into _obj_attr (obj,attr,val)
	              (select (select obj from _objs where _objs.node_id=obj_attr_tmp.node_id and _objs.name=obj_attr_tmp.name) as obj, attr, val from obj_attr_tmp where (node_id,name,attr) not in (select a.node_id,a.name,b.attr from _objs a join _obj_attr b on a.obj=b.obj))";
	              #(select (select obj from _objs where _objs.node_id=obj_attr_tmp.node_id and _objs.name=obj_attr_tmp.name) as obj, attr, val from obj_attr_tmp where (node_id,name) not in (select node_id,name from _objs join _obj_attr on _objs.obj=_obj_attr.obj))";
	    $res_i=$dbh->do($query);

	    for my $a (keys(%hosts))#(@{$nod->{DOMAIN}[0]->{NODE}})
	    {
	        my $UR="http://$hosts{$a}{'IP'}/api/cgi-bin/devinfo.cgi?return=conf".((defined $SID and $SID!=1)?"&sid=$SID":'');
	        my $xmlstr_n=get("$UR");
	        next if (! defined($xmlstr_n));
	        my $dev_nod = XMLin($xmlstr_n, ForceArray => 1);
	        my %dev_2_check;

	        for my $dev_list (@{$dev_nod->{DEVICE}}) # prepare list of devices to check is device has up to date objid
	        {
	          my $name_2_check=$dev_list->{ID};
	          my $objid_2_check=$dev_list->{OBJID}[0]->{VALUE};
	          $dev_2_check{$name_2_check}=$objid_2_check;
	        }
	        # make a list of devices for call back devinfo.cgi with OBJ attr updated

	        $query ="select a.obj, a.name, a.node_ip, c.val  from _objs a,  dev_tmp b, _obj_attr c  where  a.name=b.name and a.node_id = b.node_id and c.obj=a.node_id and c.attr= 'LAN_HTTP_PORT'";
	        my $sth_tmp=$dbh->prepare($query);
	        $sth_tmp->execute;
	        my $d_list = $sth_tmp->fetchall_hashref("obj");
	        foreach my $d_obj (keys(%$d_list))
	        {
	            if ($d_list->{$d_obj}->{'obj'} ne $dev_2_check{$d_list->{$d_obj}->{'name'}})
	            {
	                my $UR_BACK="http://$d_list->{$d_obj}->{'node_ip'}:$d_list->{$d_obj}->{'val'}/api/cgi-bin/devinfo.cgi?modify=update&devid=$d_list->{$d_obj}->{'name'}&OBJID=$d_list->{$d_obj}->{'obj'}".((defined $SID and $SID!=1)?"&sid=$SID":'');
	                get("$UR_BACK");
	            }
	        }
	    }
        #enforce obj into attr="objid" in _obj_attr           GLOBALLY!!!!!!
        $query = "update _obj_attr set val=obj where obj in (select a.obj from _objs a JOIN (select obj,val from _obj_attr where attr='OBJID') b on b.obj=a.obj where a.otype='D' and a.subtype !='N') and _obj_attr.attr='OBJID'";
        $res_u=$dbh->do($query);
	}

	if ($count != 0)
	{
		$query="
	    insert into _links (obj_res,obj_cons,link_type,credentials,protected) select a.obj ,'0' as obj_cons,'D2S' as link_type,'' as credentials,'1' as protected from _objs a where a.obj not in (select obj_res from _links where obj_cons=0) and otype in ('D');
	    insert into _links (obj_res,obj_cons,link_type,credentials) select a.obj ,'1' as obj_cons,'G2S' as link_type,'' as credentials from _objs a where a.obj not in (select obj_res from _links where obj_cons=1) and otype in ('G')
	    ";
	    my $rr=$dbh->do($query);
		print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Resource refresh request successful, updated $count devices\"/>\n</RESULT>\n";
	}
	else
	{
		print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Resource refresh request error\n $message\"/>\n</RESULT>\n";
	}
	$dbh->disconnect();
}

#===========================================refreshOne===========================================================
# function allow to refresh only one one device
# if it is new device - it will be insert into _objs
#
# also function make a call back to the node for update obj parametr for colled device
#
sub refreshOne {
    my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);
    my $rows = 0;
    my $query = "";
    $message="REFRESHRESOURCES ONE DEVICE ";
    if ($args{NODEID})
    {
		print STDERR "crdmng.cgi?modify=refreshresources&NODEID=xx is not supported anymore!!!";
		print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"crdmng.cgi?modify=refreshresources&amp;NODEID=xx is not supported anymore!!!\"/>\n</RESULT>\n";
		exit 1;
	}
    elsif($args{NODENAME})
    {
        if ($args{NODENAME}=~/MYIP/i)
        {
			print STDERR "crdmng.cgi?modify=refreshresources&NODENAME=MYIP is not supported anymore!!!";
			print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"crdmng.cgi?modify=refreshresources&amp;NODENAME=MYIP is not supported anymore!!!\"/>\n</RESULT>\n";
			exit 1;
        }
        else
        {
            $query="select a.obj, a.node_id as NODID, a.name as UNI, a.name, b.val as HOST, a.deleted, i.val as IP
			          from _objs a, _obj_attr b, _obj_attr i
					 where a.node_id=(select obj from _objs where name=?)
					   and a.name=?
					   and b.attr=\'HOST\'
					   and i.obj=a.node_id
					   and i.attr='IP'
					   and b.obj=a.node_id";
        }
    }
    if ($query) #try found OBJ in _objs
    {
        my $sth_o=$dbh->prepare($query);
		#print "<!-- 1120: $query -->\n";
        $rows=$sth_o->execute($args{NODENAME}, $args{DEVID});
        my @ws=$sth_o->fetchall_arrayref({});
        if ($rows)
        {
            my $a=is_it_same(@ws);
            if (!$a)
            {
                $rows=0;
                $log->debug( 'IT IS New device and must get a new  OBJID' );
            }
        }
        if ($rows<1) # if device not exist in DB! we are going to insert new record
        {
            if ($args{NODEID})
            {
				print STDERR "crdmng.cgi?modify=refreshresources&NODEID=xx is not supported anymore!!!";
				print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"crdmng.cgi?modify=refreshresources&amp;NODEID=xx is not supported anymore!!!\"/>\n</RESULT>\n";
				exit 1;
            }
            elsif($args{NODENAME})
            {
                if ($args{NODENAME}=~/MYIP/i)
                {
					print STDERR "crdmng.cgi?modify=refreshresources&NODENAME=MYIP is not supported anymore!!!";
					print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"crdmng.cgi?modify=refreshresources&amp;NODENAME=MYIP is not supported anymore!!!\"/>\n</RESULT>\n";
					exit 1;
                }
                else
                {
					$query="select b.obj as NODID, b.val as HOST, a.name as UNI
					          from _objs a, _obj_attr b
							 where b.attr=\'HOST\'
							   and b.obj=a.obj
							   and a.name=?";
                }
            }
            my $sth=$dbh->prepare($query);
			#print "<!-- 1157: $query -->\n";
            $sth->execute($args{NODENAME});
            my @ws=$sth-> fetchall_arrayref({});
            $message.="ON THE NODE ID=$ws[0][0]->{'nodid'}";
            my $UR="http://$ws[0][0]->{'host'}/api/cgi-bin/devinfo.cgi?return=conf".(($args{DEVID})?"&devid=$args{DEVID}":'').((defined $SID and $SID!=1)?"&sid=$SID":'');
            #my $xmlstr=`curl "$UR"`;
            my $xmlstr=get("$UR");

            if(!$xmlstr)
            {
                $message=" DEVICE DEVID=$args{DEVID} does not exist";
                return 0;
            }
            my $dev_nod = XMLin($xmlstr, ForceArray => 1);
            if (!$dev_nod->{DEVICE})
            {
               # $query="update _objs set deleted=1  where name=\'$args{DEVID}\' and node_id=\'$ws[0][0]->{'nodid'}\'";
               # $rows=$dbh->do($query);
                $message=" DEVICE DEVID=$args{DEVID} does not exist";
                return 0;

            }
            else
            {
                for my $dev_list (@{$dev_nod->{DEVICE}}) # run insert to _objs and _obj_attr for device
                    {

                        my $name=$dev_list->{DEVID}[0]->{VALUE};
                        my $description=$dev_list->{NAME}[0]->{VALUE};
                        if (!defined ($description))
                        {
                          $log->warn("Dev $name from server $ws[0][0]->{'host'} get empty conf FILE");
                          $err_message.="Dev $name from server $ws[0][0]->{'host'} get empty conf FILE";
                          $message=" DEVICE DEVID=$args{DEVID} does not exist";
                          return 0;
                        }
                        $dev_list->{DEVICETYPE}[0]=~/(.)/;
                        my $subtype=$1;
                        my $node_id=$ws[0][0]->{'nodid'};
                        my $node_ip=$ws[0][0]->{'uni'};
                        my $location=$dev_list->{LOCATION}[0]->{VALUE};
                        my $obj_atr=(($dev_list->{POSITIONCTL}[0]->{VALUE})?"$dev_list->{POSITIONCTL}[0]->{VALUE}":'');
                        my $sth = $dbh->prepare( q{
                            insert into _OBJ_ATTR ( obj, attr, val) VALUES (?,?,?)
                            });

						# insert new device into _objs
                        $query= "insert into _objs ( otype, subtype, name, description,node_id, node_ip,location,obj_atr,deleted) VALUES (\'D\',\'$subtype\', \'$name\', \'$description\',\'$node_id\', \'$node_ip\', \'$location\', \'$obj_atr\',\'0\')";
                        #print "<!-- $query -->";
						$rows=$dbh->do($query);
                        if ($rows==1)
                        {
                          $query = "select currval('seq_obj')";
                          my @ret_obj = $dbh->selectrow_array($query);
                          #!!!!!!!!!!!!!! obj=$ret_obj[0];
                          $message.=" OBJ=$ret_obj[0] SUCCESSFULL";

                            # insert all ATTR into _obj_attr
                            my %tmp_dev=%{$dev_list};
                            for my $attr (keys %tmp_dev)
                            {
                                my $val ='';
                                my $rows_s=0;
                                if ($tmp_dev{$attr}=~/ARRAY/)
                                {
                                    if ($tmp_dev{$attr}[0]=~/HASH/)
                                    {
                                        $val =uri_unescape($tmp_dev{$attr}[0]->{VALUE});
                                    }
                                    else
                                    {
                                        $val =uri_unescape($tmp_dev{$attr}[0]);
                                    }
                                }
                                else
                                {
                                    $val =uri_unescape($tmp_dev{$attr});
                                }
                                $rows_s=$sth->execute($ret_obj[0], $attr, $val); # insert all existing obj attr into _obj_attr table
                            }
                            # call devinfo.cgi for update objid on the node
                            $UR="http://$ws[0][0]->{'host'}/api/cgi-bin/devinfo.cgi?modify=update".(($args{DEVID})?"&devid=$args{DEVID}":'')."&OBJID=$ret_obj[0]".((defined $SID and $SID!=1)?"&sid=$SID":'');
                            $log->debug("going update data by: $UR");
                            #$xmlstr=`curl "$UR"`;
                            $xmlstr=get("$UR");
                            # example:             http://192.168.100.240/api/cgi-bin/devinfo.cgi?modify=update&devid=j1&OBJID=9999999
                        }
                    }
                }
         #======= creating link into GLOBAL group
            $query="
            insert into _links (obj_res,obj_cons,link_type,credentials,protected) select a.obj ,'0' as obj_cons,'D2S' as link_type,'' as credentials,'1' as protected from _objs a where a.obj not in (select obj_res from _links where obj_cons=0) and otype in ('D');
            insert into _links (obj_res,obj_cons,link_type,credentials) select a.obj ,'1' as obj_cons,'G2S' as link_type,'' as credentials from _objs a where a.obj not in (select obj_res from _links where obj_cons=1) and otype in ('G')
            ";
            $dbh->do($query);
            return 1;
        }
        else # device is EXIST and must be updated!
        {
            $log->debug("Device founded in DB and going to be  updated");
            $message.="ON THE NODE ID=$ws[0][0]->{'nodid'}";
            my $UR="http://$ws[0][0]->{'host'}/api/cgi-bin/devinfo.cgi?return=conf".(($args{DEVID})?"&devid=$args{DEVID}":'').((defined $SID and $SID!=1)?"&sid=$SID":'');
            #my $xmlstr=`curl "$UR"`;
            my $xmlstr=get("$UR");
            my $obj_ex=$ws[0][0]->{'obj'};
            my $dev_nod = XMLin($xmlstr, ForceArray => 1);
            #print Dumper($dev_nod);
            if (!$dev_nod->{DEVICE})
            {
                $query="update _objs set deleted=1  where name=? and node_id=?";
                $rows=$dbh->do($query, undef, $args{DEVID}, $ws[0][0]->{'nodid'});
                $message=" DEVICE DEVID=$args{DEVID} marked as DELETED";
            }
            else
            {
                for my $dev_list (@{$dev_nod->{DEVICE}}) # run insert to _objs and _obj_attr for device
                    {
                        my $description=$dev_list->{NAME}[0]->{VALUE};
                        if (!defined ($description))
                        {
                          $log->warn("Dev $args{DEVID} from server $ws[0][0]->{'host'} get empty conf FILE");
                          $err_message.="Dev $args{DEVID} from server $ws[0][0]->{'host'} get empty conf FILE";
                          $message=" DEVICE DEVID=$args{DEVID} does not exist";
                          return 0;
                        }
                        my $node_id=$ws[0][0]->{'nodid'};
                        my $node_ip=$ws[0][0]->{'uni'};
                        my $location=$dev_list->{LOCATION}[0]->{VALUE};
                        my $obj_atr=(($dev_list->{POSITIONCTL}[0]->{VALUE})?"$dev_list->{POSITIONCTL}[0]->{VALUE}":'');


                        $query= "update _objs set description=\'$description\',location=\'$location\',obj_atr=\'$obj_atr\', deleted=\'0\' where obj=$obj_ex";
                        $rows=$dbh->do($query);
                        if ($rows==1)
                        {
                          $message.=" OBJ=$obj_ex SUCCESSFULL";
                          #$query = "select currval('seq_obj')";
                          #my @ret_obj = $dbh->selectrow_array($query);
                          #!!!!!!!!!!!!!! obj=$ret_obj[0];
                                my $sth_i = $dbh->prepare( q{
                                    insert into _OBJ_ATTR ( obj, attr, val) VALUES (?,?,?)
                                    });
                                my $sth_u = $dbh->prepare( q{
                                    update _OBJ_ATTR set val=? where obj=? and attr=?
                                    });


                            # insert all ATTR into _obj_attr
                            my %tmp_dev=%{$dev_list};
                            for my $attr (keys %tmp_dev)
                            {
                                my $val ='';
                                my $rows_s=0;
                                if ($tmp_dev{$attr}=~/ARRAY/)
                                {
                                    if ($tmp_dev{$attr}[0]=~/HASH/)
                                    {
                                        $val =uri_unescape($tmp_dev{$attr}[0]->{VALUE});
                                    }
                                    else
                                    {
                                        $val =uri_unescape($tmp_dev{$attr}[0]);
                                    }
                                }
                                else
                                {
                                    $val =uri_unescape($tmp_dev{$attr});
                                }

                                $rows_s=$sth_u->execute($val,$obj_ex,$attr); # update all existing obj attr into _obj_attr table
                                if ($rows_s<1)
                                {
                                    $rows_s=$sth_i->execute($obj_ex,$attr,$val);# insert all existing obj attr into _obj_attr table
                                }
                            }
                            # call devinfo.cgi for update objid on the node
                            #PS -> $UR="http://$ws[0][0]->{'host'}/api/cgi-bin/devinfo.cgi?modify=update".(($args{DEVID})?"&devid=$args{DEVID}":'')."&OBJID=$obj_ex".(($args{SID})?"&sid=$args{SID}":'');
                            #$xmlstr=`curl "$UR"`;
                            #PS -> $xmlstr=get("$UR");
                            # example:             http://192.168.100.240/api/cgi-bin/devinfo.cgi?modify=update&devid=j1&OBJID=9999999
                        }
                   }
                }
               return 1;
        }
    }
    else
    {
        #$message="UPDATE OBJ=$args{DEVID} ERROR";
        return 0;
    }

}

#===========================================modifySet===========================================================
sub  modifySet {

# id=<xx>				optional for �operation=create�
# operation=(CREATE|EDIT|DELETE)
# descr=<description>			optional
# protected=(yes|no)			optional, default �no�



  my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);
  my $rows = 0;
  my $query = "";

  unless($args{OPERATION}) {
    print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"No operation specified\"/>\n</RESULT>\n";
  }

  if ( ($args{OPERATION} =~/DELETE/i) and (defined($args{ID})))
  {
    $query = "delete from _objs where obj=? and protected=0 and otype='S'";
    $rows=$dbh->do($query, undef, $args{ID});
    $query = "delete from _links where (obj_cons=? and link_type='D2S') or (obj_res=? and link_type='S2R')";
    $rows=$dbh->do($query, undef, $args{ID}, $args{ID});
    $query = "select * from (select a.obj , b.obj_res, b.obj_cons
	      from   _objs a left outer join  _links b
	      on ( b.obj_cons=a.obj and a.obj=?)or( b.obj_res=a.obj and a.obj=?)) aa
	      where aa.obj=?";
    my $sth=$dbh->prepare($query);
    $rows=$sth->execute($args{ID}, $args{ID}, $args{ID});
#    print "$rows $query\n";
    if ( $rows==0)
    {
      print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Set manipulation request successful\"/>\n\t<SET ID=\"$args{ID}\"/>\n</RESULT>\n";
    }
    else
    {
      print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Can't delete set ID=$args{ID}, check data PROTECTED attribute\"/>\n\t<SET ID=\"$args{ID}\"/>\n</RESULT>\n";
    }
  }
  if ( ($args{OPERATION} =~/EDIT/i) and (defined($args{ID})))
  {
    my $set_str;
    my @bind_values;
    #$set_str=((defined($args{DESCR}))?" description =\'$args{DESCR}\'":'');
    #if ($set_str ne '')
    #{
   #     $set_str.=((defined($args{DESCR}))?", protected =$args{PROTECTED}":' ');
        #$set_str.=((defined($args{NAME}))?", name =\'$args{NAME}\'":' ');
    #}
    #else
    #{
 #       $set_str.=((defined($args{DESCR}))?" protected =$args{PROTECTED}":'');
    #}
    #if ($set_str eq '')
    #{
         #$set_str.=((defined($args{NAME}))?" name =\'$args{NAME}\'":'');
    #}

    if(defined $args{DESCR}) {
	$set_str = ' description=?';
	push @bind_values, $args{DESCR};
    }
    if(defined $args{NAME}) {
	$set_str .= ($set_str?',':'').' name=?';
	push @bind_values, $args{NAME};
    }

    if ($set_str)
    {
      $query = "UPDATE _objs set $set_str where obj=? and otype='S'";
      $rows=$dbh->do($query, undef, @bind_values, $args{ID});
    } #<=============================end of updated _obj part of EDIT request
    if($rows > 0)
    {
      print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Set manipulation request successful\"/>\n\t<SET ID=\"$args{ID}\"/>\n</RESULT>\n";
    }
    else
    {
      print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Not enough arguments\"/>\n\t<SET ID=\"$args{ID}\"/>\n</RESULT>\n";
    }
  }
    if ( ($args{OPERATION} =~/CREATE/i) and (defined($args{NAME})))
  {

    my @bind_values = ($args{NAME});
    push @bind_values, $args{DESCR} if defined $args{DESCR};
    $query = "INSERT INTO _objs (otype,subtype,name".
	      ((defined($args{DESCR}))? ",description":"").
	      ((defined($args{PROTECTED}))? ",protected":'').")
	      values ('S','G',?".
	      ((defined($args{DESCR}))?",?":'').
	      ((defined($args{PROTECTED}))? ",'".
	      (($args{PROTECTED} eq 'yes')?'1':'0')."'":'').")";
    $rows=$dbh->do($query, undef, @bind_values);
     if ($rows==1)
    {
      $query = "select currval('seq_obj')";
      my @row_dyna_types = $dbh->selectrow_array($query);
      print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Set manipulation request successful\"/>\n\t<SET ID=\"$row_dyna_types[0]\"/>\n</RESULT>\n";
    }
    else
    {
      print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Can't create new SET\"/>\n</RESULT>\n";
    }
  }

  $dbh->disconnect();
}



#===========================================modifyRole===========================================================
sub  modifyRole {

# id=<xx>				optional for �operation=create�
# operation=(CREATE|EDIT|DELETE)
# descr=<description>			optional
# protected=(yes|no)			optional, default �no�



  my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);
  my $rows = 0;
  my $query = "";

  if ( ($args{OPERATION} =~/DELETE/i) and (defined($args{ID})))
  {
    $query = "delete from _objs where obj=? and protected=0 and otype='R'";
    $rows=$dbh->do($query, undef, $args{ID});
    $query = "delete from _links where (obj_cons=? and link_type='S2R' and protected=0)
	      or (obj_res=? and link_type='R2U' and protected=0)";
    $rows=$dbh->do($query, undef, $args{ID}, $args{ID});
    $query = "select * from (select a.obj , b.obj_res, b.obj_cons
	      from   _objs a left outer join  _links b
	      on ( b.obj_cons=a.obj and a.obj=?)or( b.obj_res=a.obj and a.obj=?)) aa
	      where aa.obj=?";
    my $sth=$dbh->prepare($query);
    $rows=$sth->execute($args{ID}, $args{ID}, $args{ID});
#    print "$rows $query\n";
    if ( $rows==0)
    {
      print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Role manipulation request successful\"/>\n\t<ROLE ID=\"$args{ID}\"/>\n</RESULT>\n";
    }
    else
    {
      print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Can't delete role ID=$args{ID}, check data PROTECTED attribute\"/>\n\t<ROLE ID=\"$args{ID}\"/>\n</RESULT>\n";
    }
     return 1;
  }
  if ( ($args{OPERATION} =~/EDIT/i) and (defined($args{ID})))
  {
    my $set_str;
    my @bind_values;
    if ((defined($args{DESCR}))&&(defined($args{NAME})))
    {
      $set_str='description=?, name=?';
      @bind_values = ($args{DESCR}, $args{NAME});
    }
    elsif((defined($args{DESCR})))
    {
      $set_str='description=?';
      @bind_values = ($args{DESCR});
    }
    elsif((defined($args{NAME})))
    {
      $set_str='name=?';
      @bind_values = ($args{NAME});
    }
    if ($set_str)
    {
      $query = "UPDATE _objs set $set_str where obj=? and otype='R' and protected=0";
      $rows=$dbh->do($query, undef, @bind_values, $args{ID});
    } #<=============================end of updated _obj part of EDIT request
    if($rows > 0)
    {
      print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Role manipulation request successful\"/>\n\t<ROLE ID=\"$args{ID}\"/>\n</RESULT>\n";
    }
    else
    {
      print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Check arguments\"/>\n\t<ROLE ID=\"$args{ID}\"/>\n</RESULT>\n";
    }
     return 1;
  }


    if ( ($args{OPERATION} =~/CREATE/i) and (defined($args{NAME})))
  {
    my @bind_values = ($args{NAME});
    push @bind_values, $args{DESCR} if defined $args{DESCR};
    $query = "INSERT INTO _objs (otype,subtype,name".
	      ((defined($args{DESCR}))? ",description":"").
	      ((defined($args{PROTECTED}))? ",protected":'').") values ('R','*',?".
	      ((defined($args{DESCR}))?",?":'').
	      ((defined($args{PROTECTED}))? ",'".(($args{PROTECTED} eq 'yes')?'1':'0')."'":'').")";
    $rows=$dbh->do($query, undef, @bind_values);
     if ($rows==1)
    {
      $query = "select currval('seq_obj')";
      my @row_dyna_types = $dbh->selectrow_array($query);
      print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Role manipulation request successful\"/>\n\t<ROLE ID=\"$row_dyna_types[0]\"/>\n</RESULT>\n";
    }
    else
    {
      print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Can't create new ROLE\"/>\n</RESULT>\n";
    }
    return 1;
  }

  $dbh->disconnect();

    #print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Can't modify ROLE! Check arguments\"/>\n\t<ROLE ID=\"$args{ID}\"/>\n</RESULT>\n";
 return 0;
}


#===========================================modifyUser===========================================================
sub  modifyUser {

# id=<xx>				optional for �operation=create�
# operation=(CREATE|EDIT|DELETE)
# name=<name>			optional
# descr=<description>			optional



  my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);
  my $rows = 0;
  my $query = "";

  if ( ($args{OPERATION} =~/DELETE/i) and (defined($args{ID})))
  {
    my $user=GetResourceNameById($args{ID});
    $query = "DELETE FROM _obj_attr where obj = ? and attr = 'LANGUAGE'";
    $rows=$dbh->do($query, undef, $args{ID});
    $query = "delete from _objs where obj=? and protected=0 and otype='U'";
    $rows=$dbh->do($query, undef, $args{ID});
    $query = "delete from _links where obj_res=? and link_type='R2U'";
    $rows=$dbh->do($query, undef, $args{ID});
    $query = "select * from (select a.obj , b.obj_res, b.obj_cons
	      from   _objs a left outer join  _links b
	      on ( b.obj_res=a.obj and a.obj=?)) aa
	      where aa.obj=?";
    my $sth=$dbh->prepare($query);
    $rows=$sth->execute($args{ID}, $args{ID});
#    print "$rows $query\n";
    $u_log->warn("User:\"$WebUserName\" deleted user:\"$user\" ID:$args{ID}");
    if ( $rows==0)
    {
      print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"User manipulation request successful\"/>\n\t<USER ID=\"$args{ID}\"/>\n</RESULT>\n";
    }
    else
    {
      print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Can't delete user ID=$args{ID}, check data PROTECTED attribute\"/>\n\t<USER ID=\"$args{ID}\"/>\n</RESULT>\n";
    }
    return 1;
  }
  if ( ($args{OPERATION} =~/EDIT/i) and (defined($args{ID})))
  {
#=========================================== creating list of parameters===================================================
    my $set_str;#-	descr-	email-	password- name - role_combine
    my $log_str;
    my @bind_values;
    if (defined($args{NAME}))
    {
      $set_str='name=?';
      push @bind_values, $args{NAME};
	  $log_str="name=\"$args{NAME}\"";
    }
    if (defined($args{DESCR}))
    {
      $set_str.=($set_str?', ':'').'description=?';
      push @bind_values, $args{DESCR};
      $log_str.=($log_str?', ':'')."description=\"$args{DESCR}\"";
    }
    if (defined($args{PASSWORD}))
    {
      $set_str.=($set_str?', ':'').'psw=?';
      push @bind_values, $args{PASSWORD};
      $log_str.=($log_str?', ':'')."password has been changed";
    }
    if (defined($args{EMAIL}))
    {
		$set_str.=($set_str?', ':'').'email=?';
		push @bind_values, $args{EMAIL};
		$log_str.=($log_str?', ':'')."email=\"$args{EMAIL}\"";
	}

    if (defined($args{EMAIL_INT}))
    {
#		my_log("EMAIL_INT = " . $args{EMAIL_INT});
		if ($args{EMAIL_INT} || $args{EMAIL_INT} eq "0"){
			$set_str.=($set_str?', ':'').'email_int=?';
			push @bind_values, $args{EMAIL_INT};
			$log_str.=($log_str?', ':'')."email_int=\"$args{EMAIL_INT}\"";
		}else{
			$set_str.=($set_str?', ':'').'email_int=?';
			push @bind_values, undef;
			$log_str.=($log_str?', ':'')."email_int=\"$args{EMAIL_INT}\"";
		}
	}
    if (defined($args{ROLE_COMBINE}))
    {
      $set_str.=($set_str?', ':'')."role_combine='".(($args{ROLE_COMBINE}eq 'yes')?'1':'0')."'";
      $log_str.=($log_str?', ':'')."role_combine='".(($args{ROLE_COMBINE}eq 'yes')?'1':'0')."'";
    }
#=========================================== creating list of parameters===================================================
    my $olduser=GetResourceNameById($args{ID});
    if ($set_str)
    {
      $query = "UPDATE _objs set $set_str where obj=? and otype='U' ";
      $rows=$dbh->do($query, undef, @bind_values, $args{ID});
    } #<=============================end of updated _obj part of EDIT request

    my $user=GetResourceNameById($args{ID});
	# set user language
	#########################################################
	if (defined($args{LANGUAGE})){
		my $query1 = "DELETE FROM _obj_attr where obj = ? and attr = 'LANGUAGE'";
		my $stq=$dbh->prepare($query1);
		my $rows1=$stq->execute($args{ID});

		$query1 = "INSERT INTO _obj_attr (obj, attr, val) values (?,'LANGUAGE',?)";
		$stq=$dbh->prepare($query1);
		$rows1=$stq->execute($args{ID}, $args{LANGUAGE});
	}
	# eof set user language
	#########################################################

    $u_log->warn("User:\"$WebUserName\" edited user:\"$olduser\" ID:$args{ID} as $log_str");
    if($rows > 0)
    {
      print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"USER manipulation request successful\"/>\n\t<USER ID=\"$args{ID}\"/>\n</RESULT>\n";
    }
    else
    {
      print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Check arguments\"/>\n\t<USER ID=\"$args{ID}\"/>\n</RESULT>\n";
    }
    return 1;
  }
    if ( ($args{OPERATION} =~/CREATE/i) and (defined($args{NAME})))
  {
    my @bind_values;
    my $name_n=(push(@bind_values,$args{NAME})," name");
    my $decr_n=((defined($args{DESCR}))? (push(@bind_values,$args{DESCR}),",description") : "");
    my $prot_n=((defined($args{PROTECTED}))? ",protected":'');
    my $email_n=((defined($args{EMAIL}))? (push(@bind_values,$args{EMAIL}),",email") : "");
#    my $email_int_n=((defined($args{EMAIL_INT}))? (push(@bind_values,$args{EMAIL_INT}),",email_int") : "");
	my $email_int_n="";
    if (defined($args{EMAIL_INT}))
    {
		if ($args{EMAIL_INT}){
			$email_int_n = (push(@bind_values,$args{EMAIL_INT}),",email_int");
		}else{
			$email_int_n = (push(@bind_values,undef),",email_int");
		}
	}
    my $pass_n=((defined($args{PASSWORD}))? (push(@bind_values,$args{PASSWORD}),",psw") : "");
    my $r_comb_n=((defined($args{ROLE_COMBINE}))? ",role_combine":"");

    my $name_v=" ?";
    my $decr_v=((defined($args{DESCR}))?", ?":'');
    my $prot_v=((defined($args{PROTECTED}))? ",'".(($args{PROTECTED} eq 'yes')?'1':'0')."'":'');
    my $email_v=((defined($args{EMAIL}))?", ?":'');

    my $email_int_v=((defined($args{EMAIL_INT}))?", ?":'');

    my $pass_v=((defined($args{PASSWORD}))?", ?":'');
    my $r_comb_v=((defined($args{ROLE_COMBINE}))? ",'".(($args{ROLE_COMBINE} eq 'yes')?'1':'0')."'":'');

    my $language=((defined($args{LANGUAGE}))?", ?":'');

    # New user is created in two steps:
    # 1. actuallly create new user
    # 2. add user to the security guard role
    local $dbh->{AutoCommit} = 0;
    local $dbh->{RaiseError} = 1;
    my @currval;

    eval {
#	$query = "INSERT INTO _objs (otype,subtype,name $decr_n $prot_n $email_n $email_int_n $pass_n $r_comb_n)
#	         values ('U','*','$args{NAME}' $decr_v $prot_v $email_v $email_int_v $pass_v $r_comb_v)";

	$query = "INSERT INTO _objs (otype,subtype, $name_n $decr_n $prot_n $email_n $email_int_n $pass_n $r_comb_n)
	         values ('U','*',$name_v $decr_v $prot_v $email_v $email_int_v $pass_v $r_comb_v)";


	$rows = $dbh->do($query, undef, @bind_values);
	$query = "select currval('seq_obj')";
	@currval = $dbh->selectrow_array($query);
	my $user = GetResourceNameById($currval[0]);
#	$query = "INSERT INTO _links (obj_res,obj_cons,link_type,protected,credentials)
#		  values (12,?,'R2U',1,'')
#		 ";
#	$dbh->do($query, undef, $currval[0]);
	$user = $args{NAME};

	# create user language
	#########################################################
	if (defined($args{LANGUAGE})){
		my $query1 = "INSERT INTO _obj_attr (obj, attr, val) values (?,'LANGUAGE',?)";
#				 values ($user,'LANGUAGE',$args{LANGUAGE})";
		my $stq=$dbh->prepare($query1);
		my $rows1=$stq->execute($currval[0], $args{LANGUAGE});
	}
	# eof create user language
	#########################################################

	$u_log->warn("User:\"$WebUserName\" successfuly created user:\"$user\" ID:$currval[0]");
	$dbh->commit();
    };

    if ($@)
    {
      eval { $dbh->rollback() };
      print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Can't create new USER: $@\"/>\n</RESULT>\n";
    }
    else
    {
      print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"User manipulation request successful\"/>\n\t<USER ID=\"$currval[0]\"/>\n</RESULT>\n";
    }

    return 1;
  }

  $dbh->disconnect();
  return 0;
}
#===========================================modifyLink===========================================================
sub  modifyLink {

# (res_id, cons_id, link_type) - mandatory attr
# operation=(CREATE|EDIT|DELETE)
# credentials=<credentials>			optional
# level=<level>			optional



  my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);
  my $rows = 0;
  my $query = "";

  if ( ($args{OPERATION} =~/DELETE/i) and (defined($args{CONS_ID}))and (defined($args{RES_ID}))and (defined($args{LINK_TYPE})))
  {
    if($args{LINK_TYPE} eq 'R2U'){
		$query = "delete from _obj_attr where obj=? and attr='DEFAULT_ROLE_ID'";
		$rows=$dbh->do($query, undef,  $args{RES_ID});
	}

    $query = "delete from _links where obj_cons=? and obj_res=? and link_type=? and protected=0";
    $rows=$dbh->do($query, undef, $args{CONS_ID}, $args{RES_ID}, $args{LINK_TYPE});
    if ( $rows!=0)
    {
        if($args{LINK_TYPE} eq 'R2U')
        {
            my $query_l = " select * from (select a.name from _objs a where a.obj=?
        		    union all select b.description from _objs b where b.obj=?) c";
            my $sth_l=$dbh->prepare($query_l);
            my $rv_l=$sth_l->execute($args{CONS_ID}, $args{RES_ID});
            my @sets_l = $sth_l->fetchall_arrayref();
            $u_log->warn("User:\"$WebUserName\" successfuly deleted user:\"$sets_l[0][0][0]\" from role: \"$sets_l[0][1][0]\"");
        }
        if($args{LINK_TYPE} eq 'S2R')
        {
            my $query_l = " select * from (select a.name from _objs a where a.obj=?
        		    union all select b.description from _objs b where b.obj=?) c";
            my $sth_l=$dbh->prepare($query_l);
            my $rv_l=$sth_l->execute($args{CONS_ID}, $args{RES_ID});
            my @sets_l = $sth_l->fetchall_arrayref();
            $u_log->warn("User:\"$WebUserName\" successfuly deleted link  between role:\"$sets_l[0][0][0]\" and set: \"$sets_l[0][1][0]\"");
        }
        print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Link manipulation request successful\"/>\n\t<LINK RES=\"$args{RES_ID}\" CONS=\"$args{CONS_ID}\"/>\n</RESULT>\n";
    }
    else
    {
      print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Can't delete LINK , check attributes\"/>\n\t<LINK RES=\"$args{RES_ID}\"  CONS=\"$args{CONS_ID}\"/>\n</RESULT>\n";
    }
    return 1;
  }
  elsif( ($args{OPERATION} =~/DELETE/i) and (!defined($args{CONS_ID}))and (!defined($args{RES_ID}))and (!defined($args{LINK_TYPE})))
  {
      print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Can't delete LINK , check attributes\"/>\n</RESULT>\n";
      return 1;
  }
  if ( ($args{OPERATION} =~/EDIT/i) and (defined($args{CONS_ID}))and (defined($args{RES_ID}))and (defined($args{LINK_TYPE})))
  {
#=========================================== creating list of parameters===================================================
    my $set_str;
    my @bind_vals;
    if (defined($args{CRED}))
    {
      $set_str='credentials=?';
      push @bind_vals, $args{CRED};
    }
    if (defined($args{LEVEL}))
    {
      $set_str.= ($set_str?', ':'').'level=?';
    }


		if(defined($args{DEFAULT_ROLE})){
			$query = "delete from _obj_attr where obj=? and attr='DEFAULT_ROLE_ID'";
			$rows=$dbh->do($query, undef,  $args{CONS_ID});
			if ($args{DEFAULT_ROLE} eq 'true'){
				$query = "INSERT INTO _obj_attr VALUES (?,'DEFAULT_ROLE_ID', ?);";
				$rows=$dbh->do($query, undef,  $args{CONS_ID}, $args{RES_ID});
			}
		}


#=========================================== creating list of parameters===================================================
    if (($set_str) and ($args{LINK_TYPE} ne 'R2U' ))
    {


      $query = "UPDATE _links set $set_str where obj_cons=? and obj_res=? and link_type=? and protected=0";
      $rows=$dbh->do($query, undef, @bind_vals, $args{CONS_ID}, $args{RES_ID}, $args{LINK_TYPE});
    } #<=============================end of updated _link part of EDIT request
    if($rows > 0)
    {
      print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"LINK manipulation request successful\"/>\n\t<LINK RES=\"$args{RES_ID}\"  CONS=\"$args{CONS_ID}\"/>\n</RESULT>\n";
    }
    elsif($args{LINK_TYPE} eq 'R2U')
    {
      print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Operation not permited\"/>\n\t<LINK RES=\"$args{RES_ID}\"  CONS=\"$args{CONS_ID}\"/>\n</RESULT>\n";
    }
    else
    {
      print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Check arguments\"/>\n\t<LINK RES=\"$args{RES_ID}\"  CONS=\"$args{CONS_ID}\"/>\n</RESULT>\n";
    }
    return 1;
  }
  elsif(($args{OPERATION} =~/EDIT/i) and (!defined($args{CONS_ID}))and (!defined($args{RES_ID})))
  {
    print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Can't edit LINK! Check arguments\"/>\n\t<LINK RES=\"$args{RES_ID}\"  CONS=\"$args{CONS_ID}\"/>\n</RESULT>\n";
    return 1;
  }
  #=================================================Link Create======================================================
  if ( ($args{OPERATION} =~/CREATE/i) and (defined($args{CONS_ID}))and (defined($args{RES_ID}))and (defined($args{LINK_TYPE})))
  {
    if((($args{LINK_TYPE} ne 'R2U') and (defined($args{CRED})))or(($args{LINK_TYPE} eq 'R2U') and (!defined($args{CRED}))))
    {
        if($args{LINK_TYPE} eq 'S2R')
        {
			my $m_cred=((defined($args{CRED})) ? $args{CRED} : '');
			my $query_set = "select distinct l2.obj_cons from _links l2 where l2.obj_cons=? and l2.link_type='D2S' and l2.deleted=0 and obj_cons in (select distinct l2.obj_cons from _links l2 where l2.link_type='D2S' and l2.deleted=0 and l2.obj_res in (select o.obj from _objs o where o.otype='X')) and obj_cons not in (select distinct l2.obj_cons from _links l2 where l2.link_type='D2S' and l2.deleted=0 and l2.obj_res in (select o.obj from _objs o where o.otype<>'X'));";
            #my $query_set = "select distinct l2.obj_cons from _links l2 where l2.obj_cons=? and l2.link_type='D2S' and l2.deleted=0 and l2.obj_res in (select o.obj from _links l, _objs o where l.obj_res=o.obj and o.otype='X');";
            my $sth_set=$dbh->prepare($query_set);
            my $rv_set=$sth_set->execute($args{RES_ID});
			if ($rv_set > 0){
				if (index($m_cred,'H') == -1){
					$m_cred = $m_cred . 'H';
				}
			}
			if ($m_cred ne ''){
				$args{CRED} = $m_cred;
			}
		}

      my @bind_values;
      my $cred_n=((defined($args{CRED}))? (push(@bind_values,$args{CRED}),",credentials"):"");
      my $lev_n=((defined($args{LEVEL}))? (push(@bind_values,$args{LEVEL}),",level"):'');


      my $cred_v=((defined($args{CRED}))?", ?":'');
      my $lev_v=((defined($args{LEVEL}))? ",?":'');



      $query = "INSERT INTO _links (obj_res,obj_cons,link_type $cred_n $lev_n ) values (?,?,? $cred_v $lev_v )";
      $rows=$dbh->do($query, undef, $args{RES_ID}, $args{CONS_ID}, $args{LINK_TYPE}, @bind_values);
      if ($rows==1)
      {
        if($args{LINK_TYPE} eq 'R2U')
        {
			if(defined($args{DEFAULT_ROLE})){
				$query = "delete from _obj_attr where obj=? and attr='DEFAULT_ROLE_ID'";
				$rows=$dbh->do($query, undef,  $args{CONS_ID});
				if ($args{DEFAULT_ROLE} eq 'true'){
					$query = "INSERT INTO _obj_attr VALUES (?,'DEFAULT_ROLE_ID', ?);";
					$rows=$dbh->do($query, undef, $args{CONS_ID},  $args{RES_ID});
				}
			}

            my $query_l = " select * from (select a.name from _objs a where a.obj=?
        		    union all select b.description from _objs b where b.obj=?) c";
            my $sth_l=$dbh->prepare($query_l);
            my $rv_l=$sth_l->execute($args{CONS_ID}, $args{RES_ID});
            my @sets_l = $sth_l->fetchall_arrayref();
            $u_log->warn("User:\"$WebUserName\" successfuly add user:\"$sets_l[0][0][0]\" into role: \"$sets_l[0][1][0]\"");
        }
        print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Link manipulation request successful\"/>\n\t<LINK RES=\"$args{RES_ID}\"  CONS=\"$args{CONS_ID}\"/>\n</RESULT>\n";
      }
      else
      {
        print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Can't create new LINK\"/>\n</RESULT>\n";
      }
    }
    else
    {
        print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"Can't create new LINK $args{LINK_TYPE} with credentions $args{CRED} \"/>\n</RESULT>\n";
    }
  }
  else {return 0;}

  $dbh->disconnect();
}

# TA3118: Workaround for hiding 'X' objects with ENABLED='N'
sub checkEnabled {
    my $dbh = shift;
    my $hDev = shift;
    my %objstat = ();	# 'X' objects statistics

    my $dev_list = "";
    foreach my $dev (keys %$hDev) {
	my $rec = $hDev->{$dev};
	next unless $rec->{otype} eq 'X';

	$dev_list .= "$dev,";
	$objstat{$dev}{node_id} = $rec->{node_id};
	$objstat{$dev}{subtype} = $rec->{subtype};
    }
    chop $dev_list;
    if($dev_list) {
	my $sth = $dbh->prepare("SELECT obj,val as enabled FROM _obj_attr ".
				"WHERE attr='ENABLED' AND obj in ($dev_list)");
	$sth->execute;
	my $hObjX = $sth->fetchall_hashref('obj');

	foreach my $obj (keys %$hObjX) {
	    my $enabled = $hObjX->{$obj}{enabled};
	    # Find out gateway states.
	    # If gateway is disabled all its units should be disabled, too
	    if($objstat{$obj}{subtype} ne 'G') {
	        my $gw_enabled = $hObjX->{$objstat{$obj}{node_id}}{enabled} || $enabled;
		$enabled = 'N' if $gw_enabled eq 'N' or not defined $gw_enabled;
	    }
	    $objstat{$obj}{enabled} = $enabled;
	}
    }

    return \%objstat;
}
# Workaround ends

#============================================ returnUserCredentials ========================================================
sub retUserCredentials {
    # A.Teetov: The function has been modified to return "sorted XML" for THE MATRIX

    my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);
    my @bind_values = ($args{ID});
    my $query =
		"
SELECT
    u2r.obj_cons as role,

    r_p.name as r_name,
    r_p.description as r_desc,

    d2s.obj_res as dev,
    d2s.obj_cons as sett,
    '' as d2s,

    concatFields(permission_type.credentials || s2r.special_credentials) as s2r,

    set_p.description as s_desc,
    set_p.name as s_name,
    set_p.protected as s_prot,

    dev_p.OTYPE as d_otype,
    dev_p.subtype as d_SUBTYPE,
    dev_p.description as d_DESCR,
    dev_p.location as d_LOC,
    dev_p.node_id as d_node_id

    FROM _links u2r, _links s2r, _links d2s, _objs set_p, _objs r_p, _objs dev_p, permission_type
    WHERE
        u2r.obj_res = ?
        and u2r.obj_cons = s2r.obj_cons
        and s2r.obj_res = d2s.obj_cons
        and set_p.obj = d2s.obj_cons
        and r_p.obj = u2r.obj_cons
        and dev_p.obj = d2s.obj_res
        and dev_p.deleted = 0
        and s2r.permission = permission_type.permission
	";

    if(defined $args{RES_ID}) {
	$query .= ' and  d2s.obj_res=?';
	push @bind_values, $args{RES_ID};
    }
    if(defined $args{RES_ID_LIST} and $args{RES_ID_LIST} !~ /\(\)/) {
    # RES_ID_LIST should be as follows: (id1,id2,id3)
	my $res_id_list = $args{RES_ID_LIST};
	$res_id_list =~ s/^\(//; # Remove open and close brackets
	$res_id_list =~ s/\)$//;
	my @resid_list = split(',', $res_id_list);
        push @bind_values, @resid_list;
	my $str_residlist = @resid_list ? ('?,' x $#resid_list) . '?' : 'NULL';
	$query .= " and d2s.obj_res in ($str_residlist)";
    }
    if(defined $args{ROLE_ID} and $args{ROLE_ID} !~ /COMBINED/i) {
	$query .= ' and u2r.obj_cons=?';
	push @bind_values, $args{ROLE_ID};
    }
    if(defined $args{ROLE_ID_LIST} and $args{ROLE_ID_LIST} !~ /^\(\)$/i) {
	my $role_id_list = $args{ROLE_ID_LIST};
	$role_id_list =~ s/^\(//; # Remove open and close brackets
	$role_id_list =~ s/\)$//;
	my @roleid_list = split(',', $role_id_list);
        push @bind_values, @roleid_list;
	my $str_roleidlist = @roleid_list ? ('?,' x $#roleid_list) . '?' : 'NULL';
	$query .= " and u2r.obj_cons in ($str_roleidlist)";
    }
    $query .= '
    GROUP BY
        u2r.obj_cons,

        r_p.name,
        r_p.description,

        d2s.obj_res,
        d2s.obj_cons,

        set_p.description,
        set_p.name,
        set_p.protected,

        dev_p.OTYPE,
        dev_p.subtype,
        dev_p.description,
        dev_p.location,
        dev_p.node_id
    ';
    $query .= ' ORDER BY role,dev;';

    my $sth=$dbh->prepare($query);
    my $rv=$sth->execute(@bind_values);
    my $sets_ucr = $sth->fetchall_arrayref({});

    # TA3118: Workaround for hiding 'X' objects with ENABLED='N'
    my $objstat = {};	# 'X' objects statistics
    if(not defined $args{SHOW_DISABLED} or $args{SHOW_DISABLED}!~/^yes$/i) {
	my %hDev = ();
	foreach my $rec (@$sets_ucr) {
	    my $dev = $rec->{dev};
	    next unless $rec->{d_otype} eq 'X';
	    $hDev{$dev}{node_id} = $rec->{d_node_id};
	    $hDev{$dev}{otype} = $rec->{d_otype};
	    $hDev{$dev}{subtype} = $rec->{d_subtype};
	}
	$objstat = checkEnabled($dbh, \%hDev);
    }
    # Workaround ends

    my %roles_ucr;
    if((!defined $args{ROLE_ID}) or ($args{ROLE_ID}!~/COMBINED/i))
    {
        foreach my $ind (@$sets_ucr)
        {

            if (!defined($roles_ucr{$ind->{'role'}}))
            {
				my $r_desc = defined($ind->{'r_desc'}) ? $ind->{'r_desc'} : "";
				my $r_name = defined($ind->{'r_name'}) ? $ind->{'r_name'} : "";
                $roles_ucr{$ind->{'role'}} = {'r_desc' => $r_desc, 'r_name' => $r_name};
            }
            if (!defined( $roles_ucr{$ind->{'role'}}{$ind->{'dev'}}  ))
            {
                $roles_ucr{$ind->{'role'}}{$ind->{'dev'}}{'d_descr'}= $ind->{'d_descr'};
                $roles_ucr{$ind->{'role'}}{$ind->{'dev'}}{'d_loc'} = $ind->{'d_loc'};
                $roles_ucr{$ind->{'role'}}{$ind->{'dev'}}{'d_subtype'} = $ind->{'d_subtype'};
                $roles_ucr{$ind->{'role'}}{$ind->{'dev'}}{'d_otype'} = $ind->{'d_otype'};
            }
            if (!defined($roles_ucr{$ind->{'role'}}{$ind->{'dev'}}{$ind->{'sett'}}  ))
            {
                $roles_ucr{$ind->{'role'}}{$ind->{'dev'}}{$ind->{'sett'}}{'s_desc'} = $ind->{'s_desc'};
                $roles_ucr{$ind->{'role'}}{$ind->{'dev'}}{$ind->{'sett'}}{'s_name'} = $ind->{'s_name'};
                $roles_ucr{$ind->{'role'}}{$ind->{'dev'}}{$ind->{'sett'}}{'s2r'}=$ind->{'s2r'};
                $roles_ucr{$ind->{'role'}}{$ind->{'dev'}}{$ind->{'sett'}}{'d2s'}=$ind->{'d2s'};
                $roles_ucr{$ind->{'role'}}{$ind->{'dev'}}{$ind->{'sett'}}{'s_prot'}=$ind->{'s_prot'};
            }
        }
        print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"User query request successful\"/>\n";

        foreach my $r (keys(%roles_ucr))
        {
            print "\t<ROLE ID=\"$r\" NAME=\"".uri_escape($roles_ucr{$r}->{'r_name'})."\" DESCR=\"".uri_escape($roles_ucr{$r}->{'r_desc'})."\">\n";

                my $cur_role_objs=$roles_ucr{$r};
		my @sorted_dev_list= sort {  # sort device numbers in order of device description
                           # $a & $b are device numbers + some shit like 'r_desc';
                           # if device description is not defined then put device to the end of list 'zzz'
                           my $da=($a=~/\D/)?'':(!defined $$cur_role_objs{$a}{d_descr})?'zzz': $$cur_role_objs{$a}{d_descr};
                           my $db=($b=~/\D/)?'':(!defined $$cur_role_objs{$b}{d_descr})?'zzz': $$cur_role_objs{$b}{d_descr};
                           $da cmp $db;      # alphabetical sort (case senrsitive);
                                          } keys(%{$cur_role_objs});
#               @sorted_dev_list= keys(%{$cur_role_objs});This is unsorted device list. Uncomment if sorting costs a problem
                foreach my $d (@sorted_dev_list)
                {
            	    # TA3118: Workaround for hiding 'X' objects with ENABLED='N'
                    # Skip disabled 'X' devices
                    next if defined $objstat->{$d}{enabled} and $objstat->{$d}{enabled} eq 'N';
                    # Workaround ends

                    my $res_str;
                    my $dev_cred_comb='';
                    my $set_str='';
                    if ($d=~/^\d+/)
                    {
                        $res_str="\t\t<RES_REF ID=\"$d\" OTYPE=\"${$roles_ucr{$r}{$d}}{'d_otype'}\" SUBTYPE=\"$roles_ucr{$r}{$d}{'d_subtype'}\" CRED=\"";
                        foreach my $ss (keys(%{$roles_ucr{$r}{$d}}))
                        {
                            if ($ss=~/^\d+/)
                            {
                                my $cred_d2s=(defined ${$roles_ucr{$r}{$d}}{$ss}{'d2s'})?${$roles_ucr{$r}{$d}}{$ss}{'d2s'}:'';
                                $dev_cred_comb.= defined(${$roles_ucr{$r}{$d}}{$ss}{'s2r'}) ? "${$roles_ucr{$r}{$d}}{$ss}{'s2r'}$cred_d2s" : "$cred_d2s";
                                $set_str.="\t\t\t<SET ID=\"$ss\" NAME=\"".uri_escape(${$roles_ucr{$r}{$d}}{$ss}{'s_name'})."\" DESCR=\"".uri_escape(${$roles_ucr{$r}{$d}}{$ss}{'s_desc'})."\" PROTECTED=\"${$roles_ucr{$r}{$d}}{$ss}{'s_prot'}\" CRED=\"${$roles_ucr{$r}{$d}}{$ss}{'s2r'}\"/>\n";
                            }
                        }

                        $res_str.=($dev_cred_comb?$dev_cred_comb:'')."\" DESCR=\"".escXML($roles_ucr{$r}{$d}{'d_descr'}?$roles_ucr{$r}{$d}{'d_descr'}:'')."\" LOC=\"".escXML($roles_ucr{$r}{$d}{'d_loc'}?$roles_ucr{$r}{$d}{'d_loc'}:'')."\"> \n".($set_str?$set_str:'');
                        print $res_str;
                        if ($args{GET_OBJ_ATTR_LIST})
                        {
                            my @attr_list= split( /,/, $args{GET_OBJ_ATTR_LIST});
                            my @bind_values;
                            my $attr_string;
                            foreach my $elem (@attr_list)
                            {
                                $attr_string .= '? ,';
                                push @bind_values, uc($elem);
                            }
                            chop($attr_string);
                            my $qqq="select attr,val from _obj_attr where obj=? and attr in ($attr_string)";
                            my $obj_attr=$dbh->prepare($qqq);
                            my $rv1 = $obj_attr->execute($d, @bind_values);
                            while(my $href_hist = $obj_attr->fetchrow_hashref) {
                               print "<ATTR NAME=\"".uri_escape($href_hist->{attr})."\" VAL=\"".uri_escape(defined($href_hist->{val})?$href_hist->{val}:'')."\"/>\n";
                            }
                        }
                        print "\t\t</RES_REF>\n";
                    }
                }
            print "\t</ROLE>\n";
        }
        print "</RESULT>\n";
    }
    else
    {

        foreach my $ind (@$sets_ucr)
        {
            if (!defined( $roles_ucr{$ind->{'dev'}}  ))
            {
                $roles_ucr{$ind->{'dev'}}{'d_descr'}= $ind->{'d_descr'};
                $roles_ucr{$ind->{'dev'}}{'d_loc'} = $ind->{'d_loc'};
                $roles_ucr{$ind->{'dev'}}{'d_subtype'} = $ind->{'d_subtype'};
                $roles_ucr{$ind->{'dev'}}{'d_otype'} = $ind->{'d_otype'};
                $roles_ucr{$ind->{'dev'}}{'s2r'} = $ind->{'s2r'};
                $roles_ucr{$ind->{'dev'}}{'d2s'} = $ind->{'d2s'};
            }
            else
            {
                $roles_ucr{$ind->{'dev'}}{'s2r'}.=$ind->{'s2r'};
                $roles_ucr{$ind->{'dev'}}{'d2s'}.=$ind->{'d2s'};
            }
        }
        print "<RESULT>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"User query request successful\"/>\n";


        print "\t<ROLE ID=\"COMBINED\" DESCR=\"COMBINED roles for user $args{ID}\"  >\n";
        foreach my $d (keys(%roles_ucr))
        {
    	    # TA3118: Workaround for hiding 'X' objects with ENABLED='N'
            # Skip disabled 'X' devices
            next if defined $objstat->{$d}{enabled} and $objstat->{$d}{enabled} eq 'N';
            # Workaround ends

            my $dev_cred_comb='';
            my $set_str='';
            my $res_str="\t\t<RES_REF ID=\"$d\" OTYPE=\"$roles_ucr{$d}{'d_otype'}\" SUBTYPE=\"$roles_ucr{$d}{'d_subtype'}\" CRED=\"";
                    $dev_cred_comb.="${$roles_ucr{$d}}{'s2r'}${$roles_ucr{$d}}{'d2s'}";
                    $set_str.="\t\t\t<SET ID=\"COMBINED\" NAME=\"COMBINED\" DESCR=\"Combined\" CRED=\"$roles_ucr{$d}{'s2r'}\"/>\n";


            $res_str.=$dev_cred_comb."\" DESCR=\"".uri_escape($roles_ucr{$d}{'d_descr'})."\" LOC=\"$roles_ucr{$d}{'d_loc'}\"> \n".$set_str;
            print $res_str;
                        if ($args{GET_OBJ_ATTR_LIST})
                        {
                            my @attr_list= split( /,/, $args{GET_OBJ_ATTR_LIST});
                            my @bind_values;
                            my $attr_string;
                            foreach my $elem (@attr_list)
                            {
                                $attr_string .= '?,';
                                push @bind_values, uc($elem);
                            }
                            chop($attr_string);
                            my $qqq="select attr,val from _obj_attr where obj=? and attr in ($attr_string)";
                            my $obj_attr=$dbh->prepare($qqq);
                            my $rv1 = $obj_attr->execute($d, @bind_values);
                            #print "<AAA= \"$attr_string $rv1 \"/>\n";
                            while(my $href_hist = $obj_attr->fetchrow_hashref) {
                               print "<ATTR NAME=\"".uri_escape($href_hist->{attr})."\" VAL=\"".uri_escape($href_hist->{val})."\"/>\n";
                            }
                        }

            print "\t\t</RES_REF>\n";
        }
        print "\t</ROLE>\n";
        print "</RESULT>\n";
    }
    $dbh->disconnect;
}
#=================================================================================================
sub returnTransl
{

    my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);
    if ($args{NODENAME})
    {
        if($args{NODENAME}=~/MYIP/i)
        {
			print STDERR "crdmng.cgi?return=transl&NODENAME=MYIP is not supported anymore!!!";
			print "<RESULT>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"crdmng.cgi?return=transl&amp;NODENAME=MYIP is not supported anymore!!!\"/>\n</RESULT>\n";
			exit 1;
        }
        else
        {
            my $query ="
			select obj,name,otype,subtype
			  from _objs
			 where node_id=(select obj from _objs where otype='D' and subtype='N' and name=?) and deleted=0";
            my $sth=$dbh->prepare($query);
            my $rv=$sth->execute($args{NODENAME});
            return 0 if($rv<1);
            my $transl = $sth->fetchall_hashref("name");
            print "<RESULT>\n<STATUS VALUE=\"OK\" MESSAGE=\"Translate ID request successful\"/>\n<RESOURCES>\n";
            foreach my $tr_obj (keys(%$transl))
            {
                print "<RESOURCE  NAME=\"".uri_escape($transl->{$tr_obj}->{'name'})."\" OBJ=\"$transl->{$tr_obj}->{'obj'}\" OTYPE=\"$transl->{$tr_obj}->{'otype'}\" SUBTYPE=\"$transl->{$tr_obj}->{'subtype'}\" />\n";
            }
            print "</RESOURCES>\n</RESULT>\n";
        }
    }
    elsif($args{NODEID})
    {
        my $query ="select obj,name,otype,subtype from _objs where node_id=? and deleted=0";
        my $sth=$dbh->prepare($query);
        my $rv=$sth->execute($args{NODEID});
        return 0 if($rv<1);
        my $transl = $sth->fetchall_hashref("name");
        print "<RESULT>\n<STATUS VALUE=\"OK\" MESSAGE=\"Translate ID request successful\"/>\n<RESOURCES>\n";
        foreach my $tr_obj (keys(%$transl))
        {
            print "<RESOURCE  NAME=\"".uri_escape($transl->{$tr_obj}->{'name'})."\" OBJ=\"$transl->{$tr_obj}->{'obj'}\" OTYPE=\"$transl->{$tr_obj}->{'otype'}\" SUBTYPE=\"$transl->{$tr_obj}->{'subtype'}\" />\n";
        }
        print "</RESOURCES>\n</RESULT>\n";
    }
}
#==========================================is_it_same=========================
# checking device in DB against server data
# return 0 if device get attribute 'DELETED' or provide different attributes then stored in db
# return 1 in case device restored with same parameters
sub is_it_same
{
    my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);
    my @ws=shift;
    return 1 if(!$ws[0][0]->{'deleted'});
    my $UR="http://$ws[0][0]->{'ip'}/api/cgi-bin/devinfo.cgi?return=conf&devid=$ws[0][0]->{'name'}".((defined $SID and $SID!=1)?"&sid=$SID":'');
    my $xmlstr=get("$UR");
    my $obj_ex=$ws[0][0]->{'obj'};
    my $dev_nod = XMLin($xmlstr, ForceArray => 1);
    if (!$dev_nod->{DEVICE})
    {
        $log->debug("posox =>XML has no DEVICE node");
        return 0;
    }
    for my $dev_list (@{$dev_nod->{DEVICE}}) # run check against _obj_attr for device
    {
        my $description=$dev_list->{NAME}[0]->{VALUE};
        if (!defined ($description))
        {
           $log->debug( "posox =>DEVICE has no description");
           return 0;
        }
        my $sth_chck = $dbh->prepare( q{select val from _OBJ_ATTR where obj=? and attr=?});
        my %tmp_dev=%{$dev_list};
        for my $attr (keys %tmp_dev)
        {
            my $val ='';
            my $rows_chck=0;
            if ($tmp_dev{$attr}=~/ARRAY/)
            {
                if ($tmp_dev{$attr}[0]=~/HASH/)
                {
                    $val =uri_unescape($tmp_dev{$attr}[0]->{VALUE});
                }
                else
                {
                    $val =uri_unescape($tmp_dev{$attr}[0]);
                }
            }
            else
            {
                $val =uri_unescape($tmp_dev{$attr});
            }
            $rows_chck=$sth_chck->execute($obj_ex,$attr); # take existing obj attr from _obj_attr table
            my @val_chck=$sth_chck-> fetchall_arrayref({});
            #print "param is:$val_chck[0][0]->{'val'}  from server: $val\n\n";
            if ($val ne $val_chck[0][0]->{'val'} )
            {
                $log->debug( "posox =>DB is different then CONF:$val /=/ $val_chck[0][0]->{'val'} ");
                my $query= "update _objs set name=name||'_'||obj where name ='$ws[0][0]->{name}' and deleted=1";
                my $rows=$dbh->do($query);
                return 0;
            }
        }
    }
    return 1;
}

# ---------------------------------returnWhoAmI----------------------------------
sub returnWhoAmI
{
    #my $attr='';
    #$attr= 'NAME' if $args{ATTR} =~/NAME/i;
    #$attr= 'ID' if $args{ATTR} =~/ID/i;
    #my $WEB_USER = GetWebUser($attr);
    #my $WEB_USER_IP= $ENV{'REMOTE_ADDR'};
    my $attr = "";
    $attr = $WebUserName if not defined $args{ATTR} or $args{ATTR} =~ /NAME/i;
    $attr = $WebUserID if $args{ATTR} =~ /ID/i;
    $attr = 'anonim' unless defined $attr;	# Left for compatibility
    my $ip = $ENV{REMOTE_ADDR};

    if ($attr ne 'anonim') {
	print "<RESULT>\n<STATUS VALUE=\"OK\" MESSAGE=\"WHOAMI request successful\"/>\n<WHOAMI VAL=\"$attr\" ADDR=\"$ip\"/>\n</RESULT>\n";
    }
    else {
        print "<RESULT>\n<STATUS VALUE=\"ERROR\" MESSAGE=\"WHOAMI request problem, no valid user name from $ip found\"/>\n</RESULT>\n";
    }
    return 1;
}#returnWhoAmI

# ---------------------------------GetWebUser----------------------------------
# internal function to get ID/NAME of user
sub GetWebUser
{
    my $sess = WEBSessionID();
    my $WEB_USER = '';
    my $attr=shift;
    $attr= 'NAME' if !$attr;
    if ($sess)
    {
        $WEB_USER=WEBUserID($sess ,$attr);
        return $WEB_USER;
    }
    else
    {
        if ($args{SID})
        {
            $WEB_USER=WEBUserID($args{SID} ,$attr);
            return $WEB_USER;
        }
        else
        {
            return "ANONIM";
        }
    }
}
# ---------------------------------GetResourceNameById----------------------------------
# internal function to get NAME of resource
sub GetResourceNameById
{
    my $id=shift;
    my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);
    my $query ="select name from _objs where obj=?";
    my $id_name = $dbh->selectrow_array($query, undef, $id) || '';
    return $id_name;
}
