<?php
/**
 * @version $Id: call.php 33171 2015-10-18 23:36:18Z astarostin $
 * ------------------------------------------------------------------------------
 * HTTP API Interface
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2015
 * ------------------------------------------------------------------------------
 * example http://192.168.0.18/api/call.php?function=getAttribute&obj=105&attribute=UNI
 * return json object
 * {"error":"","value":"mEt2szJUNExae93iPaZwMQ"}
 * error == "" if no errors else consist error description
 *
 */

require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';

$format = "json";
$readable = false;
$response = array();
$httpErrorCode = isset($_GET["httpErrorCode"]) && $_GET["httpErrorCode"] == "true" ? true : false;

$systemStatus = Node::getSystemStatus(true);

$isSystemError = false;
if (in_array($systemStatus["status"], array("OFFLINE", "BROKEN")))
{
	$response["error"] = $systemStatus["description"];
	$response["reasons"] = $systemStatus["reasons"];
	$response["code"] = 500;

	$isSystemError = true;
}

if (!$isSystemError)
{
	$functionName = null;
	$httpMethod = null;
	switch ($_SERVER['REQUEST_METHOD'])
	{
		case "GET":
			$httpMethod = "GET";
			if (isset($_GET["function"]))
			{
				$functionName = $_GET["function"];
			}
			break;
		case "POST":
			$httpMethod = "POST";
			if (isset($_GET["function"]))
			{
				$functionName = $_GET["function"];
			} else
			if (isset($_POST["function"]))
			{
				$functionName = $_POST["function"];
			}
			break;
	}

	$namespace = "";
	if (isset($_GET["vae"]))
	{
		$namespace = 'VAE\\' . $_GET["vae"] . '\\';
	}

	$apiList = array(
		"public" => array(
			"GET" => array("API_GET_Public"),
			"POST" => array("API_POST_Public")
		),
		"full" => array(
			"GET" => array("API_GET_Public", $namespace . "API_GET"),
			"POST" => array("API_POST_Public", $namespace . "API_POST")
		),
	);

	$apiListSection = "public";
	if (SessionManager::isUserLoggedIn())
	{
		$apiListSection = "full";
	} else
	if (SessionManager::isUserLoggedIn(SessionManager::SESSION_STATUS_PASSWORD_EXPIRED))
	{
		$apiListSection = "full";
	} else {
		$sessionManager = new SessionManager();
		$sessionManager->startTempSession();
		$response["error"] = "Unauthorized access";
		$response["code"] = 401;
	}

	if (!isset($functionName))
	{
		$response["error"] = "Please specify 'function' parameter";
		$response["code"] = 404;
	} else
	if ($_SESSION[SESSION_STATUS] == SessionManager::SESSION_STATUS_PASSWORD_EXPIRED
		&&
		($httpMethod != "POST" || $functionName != "changePassword")
	)
	{
		$response["error"] = "Password expired, only 'changePassword' function is available";
		$response["code"] = 600;
	} else
	if ($functionName != "getLoginInfo" && $functionName != "version"
		&&
		Identity::getAttribute("CHECK_CSRFTOKEN") == "yes"
		&&
		isset($_SERVER["HTTP_X_TOKEN"]) && !SessionManager::checkCSRFToken($_SERVER["HTTP_X_TOKEN"])
		&&
		(
			!isset($_REQUEST['token'])
			||
			isset($_GET['token']) && !SessionManager::checkCSRFToken($_GET['token'])
			||
			isset($_POST['token']) && !SessionManager::checkCSRFToken($_POST['token'])
		)
	)
	{
		$response["error"] = "Forbidden";
		$response["code"] = 403;
	} else
	if ($httpMethod == "GET")
	{
		$response = Proxy::call($apiList[$apiListSection]["GET"], $functionName, $_GET);
	} else
	if ($httpMethod == "POST")
	{
		$response = Proxy::call($apiList[$apiListSection]["POST"], $functionName, $_POST);
	}

	/*
	// for not logged in users, for not existent methods show "Unauthorized access" error
	if (SessionManager::isUserLoggedIn(SessionManager::SESSION_STATUS_LOG_IN_PROGRESS) && $response["code"] == 400)
	{
		$response["error"] = "Unauthorized access";
		$response["code"] = 401;
	}
	*/
}

// check for ouput type
if (isset($_REQUEST['format']))
{
	if ($_REQUEST['format'] == 'xml')
		$format = 'xml';
}

// check for readable output
if (isset($_REQUEST['readable']))
{
	$readable = Template::boolVal($_REQUEST['readable']);
}

header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . "GMT");
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");

if ($format == 'json')
{
	if (isset($_SERVER['HTTP_USER_AGENT']) && (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== false || preg_match('/Trident\/\d{1,2}.\d{1,2}; rv:([0-9]*)/', $_SERVER['HTTP_USER_AGENT']) == 1))
	{
		// in some cases IE try to download response instead of viewing it
		header('Content-type: text/html; charset=utf-8');
	} else {
		header('Content-type: application/json; charset=utf-8');
	}

    if ($httpErrorCode)
    {
	    $message = str_replace ("\n", "\\n", $response["error"]);
        header("HTTP/1.0 ${response["code"]} $message");
    }

	if (!$readable)
	{
		echo json_encode($response);
	} else {
		echo Utils::json_readable_encode($response);
	}
} else
if ($format == 'xml')
{
	//header('Content-type: application/xml');
	header('Content-type: text/xml; charset=utf-8');
	echo Utils::array_to_xml($response);
}
