<?php
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';

if (isset($_SERVER['APL_CORS_ALLOW']) && !empty($_SERVER['APL_CORS_ALLOW'])) {
  // Allow Cross-origin Resource Sharing (CORS) -- http://www.w3.org/TR/cors
  // for 3rd party party requests (Originally for NGC - TISS/TASS)
  //
  header('Access-Control-Allow-Origin: ' . $_SERVER['APL_CORS_ALLOW']);
  header('Access-Control-Allow-Methods: GET');
  header('Access-Control-Allow-Credentials: true');
  header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept');
}

if (isset($_SERVER['APL_CORS_SID_ALLOW']) && $_SERVER['APL_CORS_SID_ALLOW']) {
  // Allow session ID to be passed via URL parameter
  // Workaround for CORS withCredentials support on IE8/9/10(?)
  //
  if (isset($_GET['sid'])) $_COOKIE['PHPSESSID'] = $_GET['sid'];
}

$params = array();
$result = array();
$bOk = true;
$errMsg = '';

// Check session/required parameters
//
if (!SessionManager::isUserLoggedIn())
{
	$bOk = false;
	$errMsg = 'SESSION CLOSED (MCA-0000)';
} else
if (empty($_GET['return']) || $_GET['return'] != 'mediastreamauth')
{
	$bOk = false;
	$errMsg = 'Missing or invalid parameter \'return\'';
} else
if (empty($_GET['objid']))
{
	$bOk = false;
	$errMsg = 'Missing parameter \'objid\'';
} else
if (empty($_GET['streamtype']) || ($_GET['streamtype'] != 'live' && $_GET['streamtype'] != 'archive' && $_GET['streamtype'] != 'snapshot'))
{
	$bOk = false;
	$errMsg = 'Missing or invalid parameter \'streamtype\'';
} else {
	// Set default values
	//
	if (empty($_GET['player']))
	{
		$_GET['player'] = 'MPLAYER';
	}
	if (empty($_GET['analytics']))
	{
		$_GET['analytics'] = null;
	}

	$response = Proxy::call(array("API_GET"), "authorizationManager", $_GET);
	if ($response["code"] == 200)
	{
		$result = $response["result"];
	} else {
		$bOk = false;
		$errMsg = $response["error"];
	}
}

// Print output
//
header('Content-type: text/xml');
print "<?xml version=\"1.0\" ?>\n";
print "<RESULT>\n";

/*
  print " <!-- === DEBUG ===================== -->\n";
  foreach($params as $param => $value) {
    $value = str_replace(chr(26), '', $value);
    $value = str_replace('<', '&lt;', $value);
    $value = str_replace('>', '&gt;', $value);
    $value = str_replace('"', '&quot;', $value);
    $value = str_replace('&', '&amp;', $value);
    $value = str_replace('=', '&#61;', $value);
    print " <DEBUG NAME=\"${param}\" VALUE=\"${value}\"/>\n";
  }
  print " <!-- ======================== -->\n";
*/

if ($errMsg)
{
	$errMsg = str_replace('<', '&lt;', $errMsg);
	$errMsg = str_replace('>', '&gt;', $errMsg);
	$errMsg = str_replace('&', '&amp;', $errMsg);
	$errMsg = str_replace('=', '&#61;', $errMsg);
	$errMsg = str_replace('"', '&quot;', $errMsg);
}
$errMsgAttr = (empty($errMsg) ? '' : " MESSAGE=\"${errMsg}\"");

if ($bOk)
{
	print "<STATUS VALUE=\"OK\" $errMsgAttr />\n";
	print "<AUTHORIZATION ID=\"" . htmlentities($result['authid'], ENT_QUOTES, 'UTF-8') . "\" URL=\"" . urlencode($result['url']) . "\">\n";

	$outParams = array('MEDIA_TRANSPORT', 'DEVICE_TYPE', 'TIME_ZONE', 'FRAMERATE', 'PIXEL_ASPECT_RATIO', 'POSITIONCTL', 'MULTICAST_STREAM');
	foreach ($outParams as $i => $outParamName)
	{
		if (isset($result["param"][$outParamName]))
		{
			print "<PARAM NAME=\"${outParamName}\" VALUE=\"" . urlencode($result["param"][$outParamName]) . "\"/>\n";
		}
	}
	print "</AUTHORIZATION>\n";
} else {
	print "<STATUS VALUE=\"ERROR\"${errMsgAttr}/>\n";
}

print "</RESULT>\n";
