Alias /api/ /opt/sarch/api/html/

<Directory /opt/sarch/api/html>
    AllowOverride None
    # SymLinksIfOwnerMatch due to RewriteRule
    Options -ExecCGI -FollowSymLinks +SymLinksIfOwnerMatch -MultiViews -Indexes -IncludesNOEXEC
    Require all granted
    <IfModule mod_rewrite.c>
        RewriteEngine On

        # rule for download files
        RewriteBase /api/
        RewriteRule ^(\d+)/(\d+)/.*$ download.php?obj=$1&blockId=$2

        # rule for api calls from vae modules
        RewriteBase /api/
        RewriteRule ^vae/(\w+)/call\.php$ call.php?vae=$1&%{QUERY_STRING}

        # rule for api calls
        RewriteBase /api/
        RewriteRule ^call/(\w+)$ call.php?function=$1&%{QUERY_STRING}&httpErrorCode=true
    </IfModule>
</Directory>

<Location /api/ntlm_auth_request.php>
    <IfModule mod_auth_ntlm_winbind.c>
        AuthName "NTLM Authentication thingy"
        NTLMAuth on
        NTLMAuthHelper "/usr/bin/ntlm_auth --helper-protocol=squid-2.5-ntlmssp"
        NTLMBasicAuthoritative on
        AuthType NTLM
        Require valid-user
        ErrorDocument 401 /api/ntlm_auth_error.php
    </IfModule>
</Location>
