#!/usr/bin/php
<?php
/**
 * @version $Id: php_session_clean.php 33507 2016-01-13 23:52:18Z astarostin $
 * ------------------------------------------------------------------------------
 * php_session_clean.php --clean
 * remove all sessions
 *
 * php_session_clean.php
 * remove sessions older system uptime, then remove expired sessions every 60 seconds
 *
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2012
 * ------------------------------------------------------------------------------
 */

require_once $_SERVER["APL"] . "/api/lib/php/bootstrap.php";

ob_end_flush();

$options = getopt("", array("clean::"));

$sessionManager = new SessionManager();

// clean all sessions
if (isset($options["clean"]))
{
	$sessionManager->gc(0);

	exit(0);
}

// clean all sessions before reboot
$content = file_get_contents("/proc/uptime");
$mathes = array();
$upTime = 0;
if (preg_match("/(\d+)\./", $content, $mathes))
{
	$upTime = $mathes[1];
}
$sessionManager->gc($upTime);

while (true)
{
	$identity = Identity::getAttributes();
	$SESSION_MAX_LIFETIME = intval($identity["SESSION_MAX_LIFETIME"]);

	$sessionManager->update();
	$sessionManager->gc($SESSION_MAX_LIFETIME * 60);

	sleep(30);
}
