#!/usr/bin/php -q
<?php
$count = 0;
$seconds = 0;
$microseconds = 500000; // 0.5 sec.
$trace_max_points = 10;

$strStyle	 = "<Style id='stylePoly'>";
$strStyle	.= "<IconStyle>";
$strStyle	.= "<color></color>";
$strStyle	.= "<scale>0.75</scale>";
$strStyle	.= "<Icon>";
$strStyle	.= "<href>http://maps.google.com/mapfiles/kml/paddle/red-circle.png</href>";
$strStyle	.= "</Icon>";
$strStyle	.= "</IconStyle>";
$strStyle	.= "<LineStyle>";
$strStyle	.= "<color>7f00ffff</color>";
$strStyle	.= "<width>1</width>";
$strStyle	.= "</LineStyle>";
$strStyle	.= "<PolyStyle>";
$strStyle	.= "<color>7f00ff00</color>";
$strStyle	.= "</PolyStyle>";
$strStyle	.= "</Style>";

while (1) {
	sleep($seconds);
	usleep(round($microseconds));	

	$if = 0;
	$dh  = opendir("/tmp");
	$files = null;
	while (false !== ($filename = readdir($dh))) {
		if(strstr($filename, 'targets-') && strstr($filename, '.xml') ) {
			$files[$if] = $filename;
			$if++;
		};
	}

	$strVE = "";
	$strVE .= "<?xml version='1.0' encoding='UTF-8'?>";
	$strVE .= "<targets>";

	$strKML = "";
	$strH  = "";
	$strH .= "<?xml version='1.0' encoding='UTF-8'?>";
	$strH .= "<kml xmlns='http://earth.google.com/kml/2.2'>";
	$strH .= "<Document>";
	if($if != 0) {
		for($j=0; $j<count($files); $j++) {
			$n_d = getNewTargetsData("/tmp/" . $files[$j]);
			if($n_d[0]) {
				for($i=0; $i<count($n_d); $i++) {
			    $strKML .= "<Placemark id='" . $n_d[$i]['id'] . "'>";
			    $strKML .= "<name>tid_c" . $j . "_" . $n_d[$i]['id'] . "</name>";
					$strKML .= "<visibility>1</visibility>";
			  	$strKML .= "<open>0</open>";
					$strKML .= "<styleUrl>#stylePoly</styleUrl>";
				  $strKML .= "<Point>";
				  $strKML .= "<extrude>1</extrude>";
				  $strKML .= "<altitudeMode>relativeToGround</altitudeMode>";
				  $strKML .= "<coordinates>" . $n_d[$i]['lon'] . "," . $n_d[$i]['lat'] . ",2.0</coordinates>";
				  $strKML .= "</Point>";
			    $strKML .= "</Placemark>";

					$strVE .= "<target id='tid_c" . $j . "_" . $n_d[$i]['id'] . "' lat='" . $n_d[$i]['lat'] . "' lon='" . $n_d[$i]['lon'] . "' alt='0.0'/>";
				}
			}
		}
		if($strKML != "") {
			$strH .= $strStyle . $strKML . "</Document></kml>";
		} else {
			$strH .= "</Document></kml>";
		}
	} else {
		$strH .= "</Document></kml>";
	}

	$strVE .= "</targets>";

	$fh = fopen('/tmp/bravo.kml.0',"w"); 
	$err = fwrite($fh, $strH); 
	fclose($fh);
	rename('/tmp/bravo.kml.0', '/tmp/bravo.kml');

	$fh = fopen('/tmp/bravo_ve.xml.0',"w"); 
	$err = fwrite($fh, $strVE); 
	fclose($fh);
	rename('/tmp/bravo_ve.xml.0', '/tmp/bravo_ve.xml');
}

function getNewTargetsData($api_call_str) {
	$configXML = File_Get_Contents($api_call_str); 
	$parser = xml_parser_create();
	xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
	xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
	xml_parse_into_struct($parser, $configXML, $values, $tags);
	xml_parser_free($parser);                
	unset($tags);
	unset($configXML);
	
	$i_count = 0;
	foreach($values as $el) {
		if( (strtoupper($el['tag']) == 'TARGET') && ($el['type'] == 'open') ) {
			$targets[$i_count]['id'] = $el['attributes']['ID'];
		}
		if( (strtoupper($el['tag']) == 'POINT') && ($el['type'] == 'complete') ) {
			if($el['attributes']['LAT']) $targets[$i_count]['lat'] = $el['attributes']['LAT'];
			if($el['attributes']['LON']) $targets[$i_count]['lon'] = $el['attributes']['LON'];
			// For future use
			//if($el['attributes']['ELEV']) $targets[$i_count]['alt'] = $el['attributes']['ELEV'];
			//if($el['attributes']['H']) $targets[$i_count]['h'] = $el['attributes']['H'];
			//if($el['attributes']['W']) $targets[$i_count]['w'] = $el['attributes']['W'];
		}
		if( (strtoupper($el['tag']) == 'TARGET') && ($el['type'] == 'close') ) {
			$i_count++;
		}
	}
	if($i_count == 0) {
		$targets[0] = false;
	}
		
	return $targets;
}	
?>