#!/usr/bin/perl
# $Id: checkAnalyticsLimitations.pl 20359 2010-10-06 12:49:16Z atsibulnik $
# -----------------------------------------------------------------------------
# Daemon to watch for resource limitation of cameras ANALYTICS
#  Note:
#   1. Should be run by apl 
#   2. Started by procctl
#   3. Based on ifinited cycle with 15 sec sleep
#   4. If dies then restarted by procctl
# ------------------------------------------------------------------------------
#  Author: Vladimir Ryabovol
#  Edited by: A Teetov
#  QA by: 
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------

use strict;
use NextCAM::Conf;
use SKM::DB;

my $APL = $ENV{APL} || '/opt/sarch';
my $APL_CONF = $ENV{APL_CONF} || "$APL/var/conf";
my $SLEEP=15;


# -----------------------------------------------------------------------------
sub checkLimits {


 my $cpu_cores = 1;

if ( $^O !~ /darwin/i ) {
    $cpu_cores = `grep ^processor /proc/cpuinfo | wc -l`;
}
else {
    $cpu_cores = `/usr/sbin/ioreg |grep -e "CPU[0-9]@"|wc -l`;
}     

 my $cur_num_of_trackers_to_run = 0;

#printf("Virtual processors: $cpu_cores\n");

 my ($ARL_num, $GMU_num, $BA1_num) = (0, 0, 0);
 my %conf = GetCfgs( ('DEVICETYPE' => 'CAMERA') );
 foreach my $dev (sort keys %conf) {
    next if $conf{$dev}{ANALYTICS} =~ /^off$/i;
    
    # check trackers resource limitation
    if($conf{$dev}{TRACKER} eq "ARL" || $conf{$dev}{TRACKER} eq "GMU") {
	# check for resource limitation
	if($cpu_cores - 2 < ++$cur_num_of_trackers_to_run) {
	    if ( $conf{$dev}{ANALYTICS} eq "Resource Limitation" ) {
                # cam_patrol will disable analytics
                # setLimit(\$conf{$dev}, "off");
            }
            else {
                setLimit(\$conf{$dev}, "Resource Limitation");
            }
	    next;
	}
    }
 }
}

sub setLimit {
#-------------------------------------------------------------------------
# rewrite configuration. do nothing if cannot open a file. ignore errors
#-------------------------------------------------------------------------
 my ($ref,$limit)=@_;
 my $dev=$$ref->{DEVID};
 return if $$ref->{ANALYTICS} eq $limit; # nothing to change, limit set already
 $$ref->{ANALYTICS}=$limit;
 unlink "$APL_CONF/conf/$dev.conf.tmp" if -f  "$APL_CONF/conf/$dev.conf.tmp";
 if (open CF,">$APL_CONF/conf/$dev.conf.tmp" ){ 
   print CF "$_=$$ref->{$_}\n" foreach( sort keys %$$ref);
   close CF;
   unlink "$APL_CONF/conf/$dev.conf" if -f  "$APL_CONF/conf/$dev.conf";
   rename "$APL_CONF/conf/$dev.conf.tmp","$APL_CONF/conf/$dev.conf";
 }

 # update DB 
 my $obj = $$ref->{OBJID};
 my $dbh;
 my $query;

 eval {
        $dbh = DBMaster({PrintError => 0, RaiseError => 1});

        $query = "UPDATE _obj_attr SET val='$limit' WHERE obj=$obj AND attr='ANALYTICS'";

        $dbh->do($query);
    };
 print("$@") if $@; 

 $dbh->disconnect() if $dbh;

}


sub setLimitation {
    my ($dev, $limitation_str) = @_;
    my $res = "";
    open CONF_ORIG, "$APL_CONF/$dev/conf";
    while(<CONF_ORIG>) {
	$_ =~ s/^ANALYTICS=.+$/ANALYTICS=$limitation_str/i;
	$res .= $_;
    }
    close CONF_ORIG;
    
    open CONF_TMP, ">$APL_CONF/conf/$dev.conf.tmp";
    print CONF_TMP "$res";
    close CONF_TMP;
    `cp $APL_CONF/conf/$dev.conf.tmp $APL_CONF/conf/$dev.conf`;
}

# MAIN =====================================================================
for(;;sleep $SLEEP) {
  checkLimits;
}

print "THIS MESSAGE WILL NEVER BE PRINTED";
