package VMXSimpleClient;

use 5.008008;
use strict;
use warnings;
use IO::Socket::INET;
use IO::Select;
use XML::Simple;
use Data::Dumper;

use vars qw($VERSION);
$VERSION = 0.01;

# Constants
my $SOCK_TMT       = 2; # seconds
# => Tags and attrs
my $XML_HEAD       = "<?xml version=\"1.0\"?>";
my $PN_CMD         = "WCMD";
my $PN_SID         = "S";
my $ID             = "ID";
my $PN_MON         = "MON";
my $REQUEST        = "request";
my $RESPONSE       = "response";
my $PN_STATUS      = "STATUS";
my $VALUE          = "value";
my $MSG            = "message";
my $PN_CELL        = "CELL";
my $PN_ASSIGNINFO  = "AssignInfo";
my $PN_TOUR        = "touring";
my $TOUR_SRC       = "SRC";
my $TOUR_SRC_OPTS  = "options";
my $TOUR_SRC_PRID  = "presetid";
my $CELL_SRC_OBJID = "sourceOBJID";
my $CELLID         = "cell_id";
my $CELLSTATE      = "cellState";
my $STATE          = "STATE";
my $SCALE          = "SCALE";
my $MONITORID      = "monitorID";
my $MONID          = "MONID";
my $PN_MATRIX      = "MATRIX";
# => Commands
my $CMD_MONLIST  = "cmd:get_mon_list";
my $CMD_MONSTATE = "cmd:get_mon_status";
my $CMD_SPLIT    = "cmd:split_mon";
my $CMD_ASSIGN   = "cmd:assign";
my $CMD_CONTROL  = "cmd:control";
my $CMD_TOURING  = "cmd:set_touring";

# Request templates
my %TPL  = (
    REQUEST       => $XML_HEAD.
        	     "<$PN_CMD $REQUEST=\"%s\">".
        	     "   <$PN_MON $ID=\"%d\"/>".
    		     "   %s</$PN_CMD>",
    REQUEST_NOMON => $XML_HEAD.
        	     "<$PN_CMD $REQUEST=\"%s\">".
        	     "   %s</$PN_CMD>",
    ASSIGNCELL    => "<$PN_ASSIGNINFO $CELLID=\"%s\"".
		     " $CELL_SRC_OBJID=\"%d\"".
		     " $CELLSTATE=\"%s\" $MONITORID=\"%d\"/>",
    CONTROLCELL   => "<$PN_CELL $ID=\"%s\"".
		     " $STATE=\"%s\" $SCALE=\"%s\" $MONID=\"%d\"/>",
    MATRIX        => "<SPLIT/><$PN_MATRIX rows=\"%d\" cols=\"%d\"/>",
    TOURING       => "<$PN_TOUR cell=\"%s\" delay=\"%d\">%s"
);

sub new {
    my $class = shift;
    bless {@_}, $class;
}

sub _log {
    warn "===> $_[1]\n" if $_[0]->{debug};
}

sub _cmd {
    my $self = shift;
    my $cmd = shift;
    
    $self->_log("cmd: $cmd");
    return unless $cmd;
    $self->{err} = "";
    my $sock = new IO::Socket::INET(
	LocalHost => 'localhost',
	PeerHost  => 'localhost',
	PeerPort  => '10002',
	Proto     => 'tcp',
	Timeout   => $SOCK_TMT
    );
    unless ($sock) {
	$self->{err} = "Cannot connect to daemon: $!";
	return;
    }
    my $select = new IO::Select($sock);
    print $sock "$cmd\n";
    if ( $select->can_read($self->{tmt} || $SOCK_TMT) ) {
	$self->{resp} = <$sock>;
	$self->_log("cmd: got $self->{resp}");
    }
    $sock->shutdown(2) if $sock;
    unless ($self->{resp}) {
	$self->{err} = "Failed to read from socket";
	$self->_log("Got no response");
	return;
    }
    $self->_parse;
}

sub _parse {
    my $self = shift;
    
    my $parsed = eval { XMLin($self->{resp}) };
    if ($@) {
	$self->{err} = "Error parsing response: $@";
	$self->_log("Parsing error: $@. Response: $self->{resp}");
	return;
    }
    $self->{parsed} = $parsed;
}

sub _response {
    my $self = shift;
    my $cmd = shift;
    
    return if $self->{err};
    my $ret = undef;
    if (!$self->{parsed}) {
	$self->{err} = "No command";
    }
    else {
	unless ($self->{parsed}{$RESPONSE} eq $cmd) {
	    $self->{err} = "Response doesn't match request";
	}
	elsif ($self->{parsed}{$PN_STATUS}{$VALUE} ne 'OK') {
	    $self->{err} = "Request failed:\n$self->{parsed}{$PN_STATUS}{$MSG}";
	    $ret = 0;
	}
	else {
	    $ret = 1;
	}
    }
    return $ret;
}

sub get_monitor_state {
    my $self = shift;
    my $monid = shift;
    
    my $cmd = sprintf($TPL{REQUEST}, $CMD_MONSTATE, $monid, "");
    $self->_cmd($cmd);
    my $res = $self->_response($CMD_MONSTATE);
    return $res unless $res;
    return $self->{parsed}{$PN_MON}{$PN_CELL};
}

sub get_monitor_list {
    my $self = shift;
    
    my $cmd = sprintf($TPL{REQUEST_NOMON}, $CMD_MONLIST, "");
    $self->_cmd($cmd);
    my $res = $self->_response($CMD_MONLIST);
    return $res unless $res;
    return $self->{parsed}{$PN_MON};
}

sub assign_stream {
    my $self = shift;
    my ($camid, $monid, $row, $col) = @_;
    
    my $acell = sprintf($TPL{ASSIGNCELL}, "Cell ${row}.${col}", $camid, "Play", $monid);
    my $cmd = sprintf($TPL{REQUEST_NOMON}, $CMD_ASSIGN, $acell);
    $self->_cmd($cmd);
    return $self->_response($CMD_ASSIGN);
}

sub split_monitor {
    my $self = shift;
    my ($monid, $nrows, $ncols) = @_;
    
    my $matrix = sprintf($TPL{MATRIX}, $nrows, $ncols);
    my $cmd = sprintf($TPL{REQUEST}, $CMD_SPLIT, $monid, $matrix);
    $self->_cmd($cmd);
    return $self->_response($CMD_SPLIT);
}

sub clear_cell {
    my $self = shift;
    my ($monid, $row, $col) = @_;
    
    my $ccell = sprintf($TPL{CONTROLCELL}, "Cell ${row}.${col}", "Empty", "Cell", $monid);
    my $cmd = sprintf($TPL{REQUEST_NOMON}, $CMD_CONTROL, $ccell);
    $self->_cmd($cmd);
    return $self->_response($CMD_CONTROL);
}

sub set_touring {
    my $self = shift;
    my ($monid, $cellid, $delay, $srcArr) = @_;
    
    my $src = "";
    foreach my $s (@$srcArr) {
	$src .= "<SRC value=\"$s->[0]\" options=\"\" ";
	$src .= "presetid=\"$s->[1]\"" if $s->[1];
	$src .= "/>";
    }
    my $tour = sprintf($TPL{TOURING}, $cellid, $delay, $src);
    my $cmd = sprintf($TPL{REQUEST}, $CMD_TOURING, $monid, $tour);
    $self->_cmd($cmd);
    return $self->_response($CMD_TOURING);
}

1;
