#!/usr/bin/perl
#  $Id:$
# -----------------------------------------------------------------------------
#  Elog client for advantor daemon
# -----------------------------------------------------------------------------
#  Author: Yaroslav Sinyatkin (yas@videonext.net)
#  Edited by: 
#  QA by:  
#  Copyright: (c) videoNEXT LLC, 2005
# -----------------------------------------------------------------------------
# ------------------------------------------------------------------------------

use strict;
use warnings;
use Data::Dumper;

use lib "/opt/sarch/common/lib"; # service API
use lib "/opt/sarch/elog/bin/perl";
use lib "/opt/sarch/elog/bin/perl/ELogIface";
use lib "/opt/sarch/imp/lib/perl"; # thrift api
use lib "/opt/sarch/fw/bin/perl";
#use FwIface::Types;

#use lib "/home/maxim/devel/VideoNext/2.6.0/elog/bin/perl";
#use lib "/home/maxim/devel/VideoNext/2.6.0/elog/bin/perl/ELogIface";

use Data::Dumper;

use NextCAM::Servicing::Client;
use FwIface::Types;
use ELog;

package AccElogClient;

use Data::Dumper;
use ObjectManagementService;
use NextCAM::Servicing::Client;

sub new
{
  	my $class = shift;

	my $service_client = NextCAM::Servicing::Client->new("s_master", 10000);

	return undef unless $service_client;

	my $elog_client = ELogClient->new($service_client->getProtocol("skm.eventlog"));

	return undef unless $elog_client;


  	my $self = {
              client	=> $elog_client
               };

  	return defined $elog_client ? bless($self, $class) : undef;
}


# create event for objid and eventtype=1
# returns '' or error message
sub send_event
{
	my ($self, $objid) = @_;

    my $action = Action->new(
                  {
                   name => "create",
                   parameters => {"objid"     => $objid,
                                  "source"    => 1,
                                  "msg"       => "Advantor event",
                                  "eventtype" => 1,
                                  "lifespan"  => 2,
                                  "when"      =>time
                                 }
                 });

    my $resp=undef;
    eval
    {
		local $SIG{ALRM} = sub { die "die by timeout\n" }; # NB: \n required
		alarm 3;
	    $resp = $self->{client}->submitAction($action);
		alarm 0;
#print ( Data::Dumper->Dump([$resp], [qw(Create Event result)]) );
    };
    if ($@ && $@->UNIVERSAL::isa("FwIface::FwException"))
    {
      return "FwIface::FwException: ". $@->{errorId}.": ".$@->{what};
    }
    else
    {
      #print("New event created: " . $resp->{parameters}{eventid} . "\n");
    }
	return'';
}
1;