analytics.classificator = {

	currentIndex: -1,
	currentId: 4,
	// Temporary!!

	objects: [
		{
			id: 0,
			name: 'Person',
			area_min: 0.45,
			area_max: 1.86,
			speed_min: 0.0,
			speed_max: 32.2
		},
		{
			id: 1,
			name: 'Vehicle',
			area_min: 3.72,
			area_max: 92.9,
			speed_min: 0.0,
			speed_max: 321.9
		},
		{
			id: 2,
			name: 'Clutter',
			area_min: 0.0,
			area_max: 0.37,
			speed_min: 0.0,
			speed_max: 80.5
		},
		{
			id: 3,
			name: 'Group of People',
			area_min: 1.95,
			area_max: 3.62,
			speed_min: 0.0,
			speed_max: 32.2
		}
	],

	init: function() {
		this.buildObjectsList();
		this.setInactive();
		this.addEventHandlers();
	},

	updateClassificatorInput: function() {
		var html = '';
		var value = $('#trk_objs').val();

		for (var i=0; i<this.objects.length; i++) {
			html += '<option value="' + this.objects[i].id + '"> ' + this.objects[i].name + '</option>';
		}
		$('#trk_objs').html(html).val(value).jaoselect({dropdown: true});
	},

	buildObjectsList: function() {

		var html = '';

		for (var i = 0; i < this.objects.length; i++) {
			html += '<option value="' + i + '">' + i + '. ' + this.objects[i].name + '</option>';
		}

		$('#classification_object').html(html);
		this.updateClassificatorInput();
	},

	addEventHandlers: function() {
		$('#classification_object').change(function() {
			analytics.classificator.setActive(this.value);
		});

		$('#add_classification').click(function() {analytics.classificator.addObject();});
		$('#remove_classification').click(function() {analytics.classificator.removeObject();});
		
		$('#classificator_list').delegate('input:checkbox', 'click', this.getFormValue);
	},

	
	setInactive: function() {
		$('#form_classification').hide();
		if (this.currentIndex >= 0) {
			$('#form_classification').unlink(this.objects[this.currentIndex]);
		}
	},

	setActive: function(index) {
		this.setInactive();
		this.currentIndex = index;

		if (this.currentIndex == -1) {
			return;
		}

		$('#form_classification').show().link(this.objects[index]);
		for (var i in this.objects[index]) {
			$(this.objects[index]).triggerHandler( "changeField!", [i, this.objects[index][i]] );
		}
	},

	addObject: function() {
		this.objects.push({
			id: this.currentId++,
			name: 'Classification object ' + this.objects.length,
			area_min: 0,
			area_max: 200,
			speed_min: 0,
			speed_max: 200
		});
		this.buildObjectsList();
		$('#classification_object').val(this.objects.length - 1).change();
	},

	removeObject: function() {
		var index = parseInt($('#classification_object').val());
		this.setInactive();

		this.objects.splice(index, 1);
		this.buildObjectsList();

		// Set active next object
		if (this.objects.length == 0) {
			this.currentIndex = -1;
			this.setInactive();
		} else {
			$('#classification_object').val(Math.min(index, this.objects.length - 1)).change();
		}
	},

	getTrkObjects: function(Ids, include) {

		if (!Ids)
			return [];

		var result = [];

		for (var i=0; i<Ids.length; i++) {
			for (var j=0; j<this.objects.length; j++) {
				if (this.objects[j].id == Ids[i]) {
					result.push({id: j, logic: include});
				}
			}
		}
		return result;
	},

	/**
	 * Aux function, clear array of classification object ids from removed ids
	 * @param Ids
	 */
	cleanTrkObjects: function(Ids) {

		if (!$.isArray(Ids))
			return [];

		var notfound = [];

		for (var i = 0; i<Ids.length; i++) {
			var found = false;
				for (var j=0; j<this.objects.length; j++) {
				if (this.objects[j].id == Ids[i]) {
					found = true;
					break;
				}
			}
			if (!found) {
				notfound.push(i);
			}
		}

		// Clean array
		for (i=0; i<notfound.length; i++) {
			Ids.splice(notfound[i], 1);
		}
		return Ids;
	},

	serialize: function() {
		var result = [];
		var fields = ['area_min', 'area_max', 'speed_min', 'speed_max'];

		for (var i=0; i<this.objects.length; i++) {

			var obj = this.objects[i];

			if (!$.trim(obj.name))
				throw {
					name: 'inputError',
					message: '"Name" field must be filled!',
					field: $('#form_classification input[name="name"]'),
					prepare: function(i) {$('#classification_object').val(i).change();}
				};

			for (var j = 0; j < fields.length; j++) {
				if (analytics.formBuilder.checkNumber(obj[fields[j]], 'number') === false)
					throw {
						name: 'inputError',
						message: 'Area and speed fields must contain float numbers',
						field: $('#form_classification input[name="' + fields[j] + '"]'),
						prepare: function(i) {$('#classification_object').val(i).change();}
					};
			}

			result.push({
				id: i,
				position: i,
				name: obj.name,
				area: {
					lowerbound: parseFloat(obj.area_min),
					upperbound: parseFloat(obj.area_max)
				},
				speed: {
					lowerbound: parseFloat(obj.speed_min),
					upperbound: parseFloat(obj.speed_max)
				}
			});
		}

		return result;
	},

	unserialize: function(data) {

		this.objects = [];

		for (var i = 0; i < data.length; i++) {
			this.objects.push({
				id: data[i].id,
				name: data[i].name,
				area_min: data[i].area.lowerbound,
				area_max: data[i].area.upperbound,
				speed_min: data[i].speed.lowerbound,
				speed_max: data[i].speed.upperbound
			});
		}

		this.currentId = data.length + 1;
		this.buildObjectsList();
	}
};
