analytics.calibrator_vca = {
	init: function(schema) {
		this.schema = schema;

		this.calibrator = analytics.player.calibrator_vca;
		analytics.player.calibrator_vca.onchange = function(field) {analytics.calibrator_vca.onchange(field)
		};

		$('#form_calibration_vca').append(analytics.formBuilder.getFormHtml(schema.properties));
		$('#form_calibration_vca select').parent().parent().hide();

		$('#form_calibration_vca :range')
			.attr('step', 0.01)
			.rangeinput({
				css: {
					input:  'range-input',
					slider: 'range-slider',
					progress: 'range-progress',
					handle: 'range-handle'}}
			);

		$('#form_calibration_vca').link(this.calibrator, {
			height: {convertBack: "range"},
			pan_angle: {convertBack: "range"},
			roll_angle: {convertBack: "range"},
			tilt_angle: {convertBack: "range"},
			vfov: {convertBack: "range"}
		});

		// Set correct values of form fields
		for (var i in this.calibrator) {
			if (typeof this.calibrator[i] === 'function' || typeof this.calibrator[i] === 'object')
				continue;

			$(this.calibrator).triggerHandler( "changeField!", [i, this.calibrator[i]] );
		}
	},

	onchange: function(field) {
		$(this.calibrator).triggerHandler( "changeField!", [field, this.calibrator[field]] );
	},

	activate: function() {
		this.calibrator.activate();
	},

	serialize: function() {
		return analytics.formBuilder.serializeForm('#pane_calibration_vca', this.schema.properties);
	},

	unserialize: function(data) {
		analytics.formBuilder.unserializeForm('#pane_calibration_vca', data);

	}
};
