/**
 * @version $Id: validate.js 29360 2013-08-16 12:30:03Z astarostin $
 * ------------------------------------------------------------------------------
 * Validation functions
 * Used for validate VAE attributes. Function names defined in the template.
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2012
 * ------------------------------------------------------------------------------
 */

(function (window)
{
	"use strict";

	window.Validate = window.Validate || {};
	Validate.VAE = Validate.VAE || {};
	Validate.VAE.ov6 = Validate.VAE.ov6 || {};

	Validate.VAE.ov6.VAE_OV6_ACTIVE = function ()
	{
		var VAE_OV6_ACTIVE = $(Validate.getObj("VAE_OV6_ACTIVE", this)).val();
		var VAE_OV6_COUNTING_ACTIVE = $(Validate.getObj("VAE_OV6_COUNTING_ACTIVE", this)).val();

        if (Validate.isAttributeVisible("VAE_OV6_ACTIVE", this) || Validate.isAttributeVisible("VAE_OV6_COUNTING_ACTIVE", this))
        {
            Validate.showAttribute("VAE_OV6_SEPARATOR", this);
        }

		var attributeList = [
			"VAE_OV6_MIN_FPS",
			"VAE_OV6_MAX_FPS",
			"VAE_OV6_VISUALIZATION",
			"VAE_OV6_CONFIGURATOR",
			"VAE_OV6_CONFIG",
			"VAE_OV6_SCHEDULER"
		];

		if (VAE_OV6_ACTIVE == "no" && VAE_OV6_COUNTING_ACTIVE == "no")
		{
			Validate.hideAttribute(attributeList, this);
		} else {
			Validate.showAttribute(attributeList, this);
		}
	};

	Validate.VAE.ov6.VAE_OV6_CONFIGURATOR = function ()
	{
		var camera_id = $(this).data("obj");
		var url = $(this).data("url");
		var error_msg = $(this).data("error");
		var self = this;

		var api = new API();
		api.getAttributes({
			obj: camera_id
		})
		.fail(function(code, message){
			Log.error("[" + code + "] " + message);
		})
		.done(function(result){
			var attributes = result.list;

			if (attributes.VAE_ACTIVE != "yes" || (attributes.VAE_OV6_ACTIVE != "yes" && attributes.VAE_OV6_COUNTING_ACTIVE != 'yes'))
			{
				Log.error(error_msg);
			} else {
				var iAdmin = require("iadmin");

				iAdmin.destroyEditor();
				iAdmin.setFrameContent('/sdi/vae/ov6/index.php?objid=' + camera_id + '&OV6=' + attributes.VAE_OV6_ACTIVE + '&OVC=' + attributes.VAE_OV6_COUNTING_ACTIVE, true);
				iAdmin.setContentHeight();
			}
		});
	};

})(window);
