#!/usr/bin/perl -w

use strict;

use lib qw(/usr/share/perl5/vendor_perl/POE/Test/Loops);
use Test::More;
use POSIX qw(_exit);

sub skip_tests {
  return "IO::Poll is not 100% compatible with $^O" if (
    $^O eq "MSWin32" and not $ENV{POE_DANTIC}
  );
  return "IO::Poll tests require the IO::Poll module" if (
    do { eval "use IO::Poll"; $@ }
  );
}


BEGIN {
  if (my $why = skip_tests('all_errors')) {
    plan skip_all => $why
  }
}

# Run the tests themselves.
require 'all_errors.pm';

_exit 0 if $^O eq 'MSWin32';
CORE::exit 0;
