/**
 * @version $id:$
 * ------------------------------------------------------------------------------
 * validate functions for identity
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2013
 * ------------------------------------------------------------------------------
 */

(function(window){
	"use strict";

	window.Validate = window.Validate || {};
	Validate.isMassObjectEditor = Validate.isMassObjectEditor || false;

	Validate.CLOUD_STORAGE_TEST_BUTTON = function()
	{
		var provider = $(Validate.getObj("CLOUD_PROVIDER", this)).val();

		var testButton = $(Validate.getObj("CLOUD_STORAGE_TEST_BUTTON", this));
		testButton.mask();

		var api = new API();
		api.getCloudStorageStatus({
			provider: provider
		})
			.fail(function(code, message){
				Log.error(message);
			})
			.done(function(response){
				testButton
					.val(__("Status: ") + __(response.status));
			})
			.always(function(){
				testButton.unmask();
			});
	};

})(window);
