<?php
/**
 * @version $Id: legacycall.php 31577 2014-12-08 13:18:24Z atsybulnik $
 * ------------------------------------------------------------------------------
 * add some old methods
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2012
 * ------------------------------------------------------------------------------
 */

namespace API\Legacy;

require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';

$response = "empty";

if ($_SERVER["SCRIPT_NAME"] == "/axis2c/services/StorageStat")
{
	$response = getStorageStat();
} else
if ($_SERVER["SCRIPT_NAME"] == "/usr/api/login.php")
{
	if (isset($_REQUEST["return"]))
	{
		$method = $_REQUEST["return"];
		switch ($method)
		{
			case "logininfo":
				$response = getLoginInfo();
				break;
			case "login":
				$username = $_GET["username"];
				$credentials = $_GET["credentials"];
				$response = login($username, $credentials);
				break;
		}
	}
} else
if ($_SERVER["SCRIPT_NAME"] == "/usr/logout.php")
{
	$response = logout();
}

header('Content-type: text/xml; charset=utf-8');
print $response;

/**
 * /usr/api/login.php?return=logininfo
 *
 * @return string
 */
function getLoginInfo()
{
	$sessionManager = new \SessionManager();
	$sessionManager->startTempSession();

	$loginInfo = $sessionManager->getLoginInfo();
	$ENCRYPTIONKEY = $loginInfo["encryptionKey"];
	$TTL = $loginInfo["loginTTL"];

	$response =
'<?xml version="1.0" ?>
<RESULT>
  <STATUS VALUE="OK"/>
  <LOGIN>
    <PARAM NAME="HASHCASHKEY" VALUE="21lRo7fjyYeT59cY"/>
    <PARAM NAME="HASHCASHBITS" VALUE="19"/>
    <PARAM NAME="ENCRYPTIONKEY" VALUE="' . $ENCRYPTIONKEY . '"/>
    <PARAM NAME="TTL" VALUE="' . $TTL . '"/>
  </LOGIN>
</RESULT>';

	return $response;
}

/**
 * /usr/api/login.php?return=login&username=$username&credentials=$credentials);
 *
 * @param string $username
 * @param string $credentials
 * @return string
 */
function login($username, $credentials)
{
	$sessionManager = new \SessionManager();
	try
	{
		$sessionManager->startSession($username, $credentials, null, true);
		$response =
'<?xml version="1.0" ?>
<RESULT>
  <STATUS VALUE="OK"/>
  <LOGIN>
    <PARAM NAME="REDIRECT-URL" VALUE="/usr/check.php"/>
  </LOGIN>
</RESULT>';
	}
	catch (\Exception $e)
	{
		$response =
'<?xml version="1.0" ?>
<RESULT>
  <STATUS VALUE="ERROR" MESSAGE="' . htmlspecialchars($e->getMessage()) . '"/>
</RESULT>';
	}

	return $response;
}

/**
 * /usr/logout.php
 *
 * @return string
 */
function logout()
{
	\SessionManager::closeSession();
	return "logout";
}

/**
 * /axis2c/services/StorageStat
 *
 * @return string
 */
function getStorageStat()
{
	/* POST
	Request
	<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" xmlns:SOAP-ENC="http://schemas.xmlsoap.org/soap/encoding/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
	<SOAP-ENV:Header xmlns:wsa="http://www.w3.org/2005/08/addressing">
		<wsa:Action>StorageStat#getCoverageCollection</wsa:Action>
	</SOAP-ENV:Header>
	<SOAP-ENV:Body>
		<jsx1:coverage_params_in xmlns:jsx1="coveragesvc.videonext.com">
			<jsx1:start_time>1375889165</jsx1:start_time>
			<jsx1:finish_time>1375891359</jsx1:finish_time>
			<jsx1:multiplier>1</jsx1:multiplier>
			<jsx1:granularity>min</jsx1:granularity>
			<jsx1:id>824</jsx1:id>
			<jsx1:session_id>123</jsx1:session_id>
		</jsx1:coverage_params_in>
	</SOAP-ENV:Body>
	</SOAP-ENV:Envelope>

	Response
	<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/">
	  <soapenv:Header xmlns:wsa="http://www.w3.org/2005/08/addressing">
		<wsa:Action>StorageStat#getCoverageCollection</wsa:Action>
		<wsa:From>
		  <wsa:Address>
		  http://demo-10.videonext.com/axis2c/services/StorageStat</wsa:Address>
		</wsa:From>
		<wsa:MessageID>
		urn:uuid:e508a04c-ff78-1e21-386d-a4badb15ebb3</wsa:MessageID>
	  </soapenv:Header>
	  <soapenv:Body>
		<ns1:coverage_params_out xmlns:ns1="coveragesvc.videonext.com">
		  <ns1:time_and_percentage>
			<ns1:time>1375889820</ns1:time>
			<ns1:percentage>50</ns1:percentage>
		  </ns1:time_and_percentage>
		  <ns1:time_and_percentage>
			<ns1:time>1375889880</ns1:time>
			<ns1:percentage>100</ns1:percentage>
		  </ns1:time_and_percentage>
		</ns1:coverage_params_out>
	  </soapenv:Body>
	</soapenv:Envelope>
	*/

	/*
	<jsx1:start_time>1375889165</jsx1:start_time>
	<jsx1:finish_time>1375891359</jsx1:finish_time>
	<jsx1:multiplier>1</jsx1:multiplier>
	<jsx1:granularity>min</jsx1:granularity>
	<jsx1:id>824</jsx1:id>
	<jsx1:session_id>123</jsx1:session_id>
	*/

	$request = file_get_contents("php://input");

	$dom = new \DOMDocument();
	$dom->loadXML($request);

	$list = $dom->getElementsByTagNameNS('coveragesvc.videonext.com', '*');
	$requestParameters = array();
	foreach ($list->item(0)->childNodes as $element)
	{
		if (get_class($element) != 'DOMElement')
			continue;

		$name = $element->localName;
		$value = $element->nodeValue;
		$requestParameters[$name] = $value;
	}

	$obj = $requestParameters["id"];
	$startTime = $requestParameters["start_time"];
	$endTime = $requestParameters["finish_time"];
	$granularity = $requestParameters["granularity"];
    $multiplier = $requestParameters["multiplier"];

    $coverage = array();
    try {
        $coverage = \Node::getStorageCoverage($obj, $startTime, $endTime, $granularity, 1, $multiplier);
    }
    catch(\Exception $e)
    {

    }

	$server = "localhost";
	$xml =
		'<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/">
		  <soapenv:Header xmlns:wsa="http://www.w3.org/2005/08/addressing">
			<wsa:Action>StorageStat#getCoverageCollection</wsa:Action>
			<wsa:From>
			  <wsa:Address>http://' . $server . '/axis2c/services/StorageStat</wsa:Address>
			</wsa:From>
			<wsa:MessageID>urn:uuid:e508a04c-ff78-1e21-386d-a4badb15ebb3</wsa:MessageID>
		  </soapenv:Header>
		  <soapenv:Body>
			<ns1:coverage_params_out xmlns:ns1="coveragesvc.videonext.com">';
		foreach ($coverage as $time => $percentage)
		{
			$xml .=
				'<ns1:time_and_percentage>
					<ns1:time>' . $time . '</ns1:time>
					<ns1:percentage>' . $percentage . '</ns1:percentage>
				  </ns1:time_and_percentage>';
		}
	$xml .=
		'	</ns1:coverage_params_out>
		  </soapenv:Body>
		</soapenv:Envelope>';

	return $xml;
}
