#!/usr/bin/python
from jsonschema import validate, ValidationError
import sys
import json

schema = {
	"type":"object",
	"properties": {
	    "__comment": "common attrs",
    	    "plate_cut_out_position": { "enum": [ "left", "right", "none" ] },
	    "image_width": { "type": "integer" },
    	    "image_height": { "type": "integer" },
    	    "scans_per_event": { "type": "integer", "minimum": 1, "maximum": 10 },
    	    "time_between_events": { "type": "number", "minimum": 0, "maximum": 5 },
    	    "time_between_scans": { "type": "number", "minimum": 0, "maximum": 1 },
    	    "zone_set": {
      		"type": "array",
      		"items": {
        		"type": "object",
        		"properties": {
          			"id": { "type": "integer", "minimum": 0 },
          			"name": { "type": "string" },
          			"color": { "enum": [ 16711680, 65280, 255, 16776960, 16711935, 65535, 16753920 ] }
        		}
      		}
    	    },

	    "__comment": "VaxOCR-specific parameters",
	    "countries": { "type": "array", "items": { "type": "string"} },
	    "states": { "type": "array", "items": { "type": "string"} },
	    "min_chars_height": { "type": "number", "minimum": 14, "maximum": 70 },
	    "max_chars_height": { "type": "number", "minimum": 14, "maximum": 70 },
	    "min_global_confidence": { "type": "number", "minimum": 0, "maximum": 100 },
	    "min_char_confidence": { "type": "number", "minimum": 0, "maximum": 100 },
	    "grammar_strict": { "type": "boolean" },
	    "min_num_plate_chars": { "type": "number", "minimum": 5, "maximum": 12 },
	    "max_num_plate_chars": { "type": "number", "minimum": 5, "maximum": 12 },
	    "max_slop_angle": { "type": "number", "minimum": 0, "maximum": 40 },
	    "background_mode": { "type": "number", "minimum": 1, "maximum": 3 },
	    "ocr_complexity": { "type": "number", "minimum": 1, "maximum": 3 },
	    "find_plate_depth": { "type": "number", "minimum": 1, "maximum": 3 },
	    "detect_multiline_plate": { "type": "boolean" },
	    "enable_multicountry_nn": { "type": "boolean" },
	    "num_threads": { "type": "number", "minimum": 1, "maximum": 16 },

	    "__comment": "VaxMMC-specific parameters",
	    "mmc_type": { "type": "number", "minimum": 0, "maximum": 3 },
	    "mmc_quality": { "type": "number", "minimum": 1, "maximum": 3 },
	    "mmc_min_global_confidence": { "type": "number", "minimum": 20, "maximum": 100 },

	    "__comment": "MD-related",
	    "md": { "type": "boolean" },
	    "min_object_width": { "type": "integer" },
    	    "min_object_height": { "type": "integer" },
	    "roi": { "type": "array", "items": { "type": "array", "items": { "type": "integer"} } }
	}
}

try:
	confs = json.loads(sys.argv[1])
	results = { "code": 200, "error": "Ok", "configurations": {} }
	for k in confs:
		try:
			validate(confs[k], schema)
			results["configurations"][k] = { "code": 200, "error": "Ok" }
		except ValidationError as e:
			results["configurations"][k] = { "code": 400, "error": e.message, "field": list(e.relative_path) }
		except Exception as e2:
			results["configurations"][k] = { "code": 500, "error": e2.message }
	print json.dumps(results)
except Exception as e:
	print json.dumps({ "code": 500, "error": e.message, "configurations": {} })