﻿using System;
using System.Collections.Generic;

using VehicleClassifierNet;
using VehicleClassifierNet.Models;

namespace VehicleClassifierNetTest
{
    class Program
    {
        static void Main(string[] args)
        {
            // Create the object
            VehicleClassifier vehicleClassifier = new VehicleClassifier("", "");

            // Initialize the Vehicle classifier for make and color. This must be called only once (for each classification type)
            // and may take a few seconds to initialize
            vehicleClassifier.LoadClassifier(ClassificationType.VEHICLE_MAKE);
            vehicleClassifier.LoadClassifier(ClassificationType.VEHICLE_COLOR);

            if (!vehicleClassifier.IsLoaded(ClassificationType.VEHICLE_MAKE) || !vehicleClassifier.IsLoaded(ClassificationType.VEHICLE_COLOR))
            {
                Console.WriteLine("Vehicle Classifier was not properly initialized.  Exiting");
                vehicleClassifier.Dispose();
                Console.ReadKey();
                return;
            }

            vehicleClassifier.setTopN(3);

            List<Candidate> make_candidates = vehicleClassifier.Classify(ClassificationType.VEHICLE_MAKE, @"c:\projects\openalpr-commercial\image.jpg");;

            Console.WriteLine("Vehicle Make:");
            foreach (Candidate candidate in make_candidates)
            {
                Console.WriteLine("  - {0} ({1}%)", candidate.value, candidate.confidence);
            }
            Console.WriteLine("");

            List<Candidate> color_candidates = vehicleClassifier.Classify(ClassificationType.VEHICLE_COLOR, @"c:\projects\openalpr-commercial\image.jpg"); ;

            Console.WriteLine("Vehicle Color:");
            foreach (Candidate candidate in color_candidates)
            {
                Console.WriteLine("  - {0} ({1}%)", candidate.value, candidate.confidence);
            }

            // Free the VehicleClassifier instance's memory.
            vehicleClassifier.Dispose();

            Console.WriteLine("\nPress any key to continue...");
            Console.ReadKey();
        }
    }
}
