
#include <stdio.h>
#include <stdlib.h>
#include <vehicle_classifier_c.h>

long read_file(const char* file_path, unsigned char** buffer)
{
    FILE *fileptr;
    long filelen;

    fileptr = fopen(file_path, "rb");     // Open the file in binary mode
    if (!fileptr)
        return 0;
    
    fseek(fileptr, 0, SEEK_END);          // Jump to the end of the file
    filelen = ftell(fileptr);             // Get the current byte offset in the file
    rewind(fileptr);                      // Jump back to the beginning of the file

    *buffer = (unsigned char *)malloc((filelen+1)*sizeof(char)); // Enough memory for file + \0
    fread(*buffer, filelen, 1, fileptr); // Read in the entire file
    fclose(fileptr); // Close the file

    return filelen;
}

int main(int argc, char *argv[])
{
    VEHICLECLASSIFIER* vc_obj;

    if (argc != 2)
    {
        printf("Usage: %s [path to image file]\n", argv[0]);
        return 1;
    }

    const char* file_path = argv[1];

    // Leaving the config and runtime directory blank to look for these in the current directory
    vc_obj = vehicleclassifier_init("", "");

    if (vehicleclassifier_is_loaded(vc_obj))
    {
        // We don't want to restrict the size of the recognition area, so we set this to an extremely large pixel size
        // rather than decode and find the actual image width/height
        struct VehicleClassifierCRegionOfInterest roi;
        roi.x = 0;
        roi.y = 0;
        roi.width = 10000;
        roi.height = 10000;

        // Read the image file
        unsigned char* buffer;
        long long length = read_file(file_path, &buffer);

        printf("file size (bytes): %d\n", length);

        if (length > 0)
        {
            char* vehicle_response = vehicleclassifier_recognize_encodedimage(vc_obj, buffer, length, roi);
            printf("Vehicle Classifier response:\n%s\n", vehicle_response);
            vehicleclassifier_free_response_string(vehicle_response);
        }

        free(buffer);


    }

    vehicleclassifier_cleanup(vc_obj);


    return 0;
}